//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.model.NodeCreationInfo;
import cn.com.antcloud.api.provider.aks.v1_0_0.model.ZoneToVSwitchId;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.CreateClusterResponse;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 创建一个新集群
 */
public class CreateClusterRequest extends AntCloudProviderRequest<CreateClusterResponse> {
  private String clusterPackageSuitVersionName;

  @NotNull
  private String displayName;

  private Boolean enableLogging;

  private Boolean enableMonitoring;

  private Boolean enableSofaMesh;

  @NotNull
  private List<String> existingSecuredGroupIds;

  @NotNull
  private String existingVpcId;

  @NotNull
  private Long maxPodAmountPerNode;

  @NotNull
  private String name;

  @NotNull
  private List<NodeCreationInfo> nodeCreationInfos;

  @NotNull
  private String operatorName;

  @NotNull
  private String podIpRange;

  @NotNull
  private String serviceIpRange;

  private String userLoginName;

  @NotNull
  private String workspace;

  @NotNull
  private List<ZoneToVSwitchId> zoneToVswitchIds;

  public CreateClusterRequest() {
    super("antcloud.aks.cluster.create", "1.0", "Java-SDK-20190814");
  }

  /**
   * 集群使用的软件版本集的名称，默认为latest */
  public String getClusterPackageSuitVersionName() {
    return this.clusterPackageSuitVersionName;
  }

  /**
   * 集群使用的软件版本集的名称，默认为latest */
  public void setClusterPackageSuitVersionName(String clusterPackageSuitVersionName) {
    this.clusterPackageSuitVersionName = clusterPackageSuitVersionName;
  }

  /**
   * 集群显示名称 */
  public String getDisplayName() {
    return this.displayName;
  }

  /**
   * 集群显示名称 */
  public void setDisplayName(String displayName) {
    this.displayName = displayName;
  }

  /**
   * 集群开启日志服务 */
  public Boolean getEnableLogging() {
    return this.enableLogging;
  }

  /**
   * 集群开启日志服务 */
  public void setEnableLogging(Boolean enableLogging) {
    this.enableLogging = enableLogging;
  }

  /**
   * 为集群开启监控
   * 默认已开启基础监控 */
  public Boolean getEnableMonitoring() {
    return this.enableMonitoring;
  }

  /**
   * 为集群开启监控
   * 默认已开启基础监控 */
  public void setEnableMonitoring(Boolean enableMonitoring) {
    this.enableMonitoring = enableMonitoring;
  }

  /**
   * 集群开启SofaMesh */
  public Boolean getEnableSofaMesh() {
    return this.enableSofaMesh;
  }

  /**
   * 集群开启SofaMesh */
  public void setEnableSofaMesh(Boolean enableSofaMesh) {
    this.enableSofaMesh = enableSofaMesh;
  }

  /**
   * 集群使用当前环境已有的安全组 */
  public List<String> getExistingSecuredGroupIds() {
    return this.existingSecuredGroupIds;
  }

  /**
   * 集群使用当前环境已有的安全组 */
  public void setExistingSecuredGroupIds(List<String> existingSecuredGroupIds) {
    this.existingSecuredGroupIds = existingSecuredGroupIds;
  }

  /**
   * 新建集群需要的vpc id
   * 当前版本只支持使用已有vpc，此项必填 */
  public String getExistingVpcId() {
    return this.existingVpcId;
  }

  /**
   * 新建集群需要的vpc id
   * 当前版本只支持使用已有vpc，此项必填 */
  public void setExistingVpcId(String existingVpcId) {
    this.existingVpcId = existingVpcId;
  }

  /**
   * 每个节点的最大Pod数目 */
  public Long getMaxPodAmountPerNode() {
    return this.maxPodAmountPerNode;
  }

  /**
   * 每个节点的最大Pod数目 */
  public void setMaxPodAmountPerNode(Long maxPodAmountPerNode) {
    this.maxPodAmountPerNode = maxPodAmountPerNode;
  }

  /**
   * 集群名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 集群名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 集群节点创建信息 */
  public List<NodeCreationInfo> getNodeCreationInfos() {
    return this.nodeCreationInfos;
  }

  /**
   * 集群节点创建信息 */
  public void setNodeCreationInfos(List<NodeCreationInfo> nodeCreationInfos) {
    this.nodeCreationInfos = nodeCreationInfos;
  }

  /**
   * 集群操作人名称 */
  public String getOperatorName() {
    return this.operatorName;
  }

  /**
   * 集群操作人名称 */
  public void setOperatorName(String operatorName) {
    this.operatorName = operatorName;
  }

  /**
   * 集群Pod网段 */
  public String getPodIpRange() {
    return this.podIpRange;
  }

  /**
   * 集群Pod网段 */
  public void setPodIpRange(String podIpRange) {
    this.podIpRange = podIpRange;
  }

  /**
   * 集群Service Cidr */
  public String getServiceIpRange() {
    return this.serviceIpRange;
  }

  /**
   * 集群Service Cidr */
  public void setServiceIpRange(String serviceIpRange) {
    this.serviceIpRange = serviceIpRange;
  }

  /**
   * 当前操作人，若开始SofaMesh则必填 */
  public String getUserLoginName() {
    return this.userLoginName;
  }

  /**
   * 当前操作人，若开始SofaMesh则必填 */
  public void setUserLoginName(String userLoginName) {
    this.userLoginName = userLoginName;
  }

  /**
   * 工作空间名称 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 工作空间名称 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }

  /**
   * 交换机各可用区交换机配置信息
   * 当前版本只支持使用已有交换机，必填！ */
  public List<ZoneToVSwitchId> getZoneToVswitchIds() {
    return this.zoneToVswitchIds;
  }

  /**
   * 交换机各可用区交换机配置信息
   * 当前版本只支持使用已有交换机，必填！ */
  public void setZoneToVswitchIds(List<ZoneToVSwitchId> zoneToVswitchIds) {
    this.zoneToVswitchIds = zoneToVswitchIds;
  }
}
