//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.CreateBuildConfigResponse;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 关联一个应用到构建中
 */
public class CreateBuildConfigRequest extends AntCloudProviderRequest<CreateBuildConfigResponse> {
  private String appBuildName;

  @NotNull
  private String appId;

  private String compileDir;

  private String compileDockerfile;

  private List<String> dockerCredential;

  private String externalDockerCredential;

  private String externalImageName;

  private String gitlabAccessId;

  @NotNull
  private String gitlabAccessToken;

  @NotNull
  private String scmUrl;

  public CreateBuildConfigRequest() {
    super("antcloud.aks.build.config.create", "1.0", "Java-SDK-20190814");
  }

  /**
   * build_name */
  public String getAppBuildName() {
    return this.appBuildName;
  }

  /**
   * build_name */
  public void setAppBuildName(String appBuildName) {
    this.appBuildName = appBuildName;
  }

  /**
   * app_id */
  public String getAppId() {
    return this.appId;
  }

  /**
   * app_id */
  public void setAppId(String appId) {
    this.appId = appId;
  }

  /**
   * 构建路径 */
  public String getCompileDir() {
    return this.compileDir;
  }

  /**
   * 构建路径 */
  public void setCompileDir(String compileDir) {
    this.compileDir = compileDir;
  }

  /**
   * Dockerfile路径 */
  public String getCompileDockerfile() {
    return this.compileDockerfile;
  }

  /**
   * Dockerfile路径 */
  public void setCompileDockerfile(String compileDockerfile) {
    this.compileDockerfile = compileDockerfile;
  }

  /**
   * docker_credential */
  public List<String> getDockerCredential() {
    return this.dockerCredential;
  }

  /**
   * docker_credential */
  public void setDockerCredential(List<String> dockerCredential) {
    this.dockerCredential = dockerCredential;
  }

  /**
   * external_docker_credential */
  public String getExternalDockerCredential() {
    return this.externalDockerCredential;
  }

  /**
   * external_docker_credential */
  public void setExternalDockerCredential(String externalDockerCredential) {
    this.externalDockerCredential = externalDockerCredential;
  }

  /**
   * external_image_name */
  public String getExternalImageName() {
    return this.externalImageName;
  }

  /**
   * external_image_name */
  public void setExternalImageName(String externalImageName) {
    this.externalImageName = externalImageName;
  }

  /**
   * gitlab_access_id */
  public String getGitlabAccessId() {
    return this.gitlabAccessId;
  }

  /**
   * gitlab_access_id */
  public void setGitlabAccessId(String gitlabAccessId) {
    this.gitlabAccessId = gitlabAccessId;
  }

  /**
   * gitlab_access_token */
  public String getGitlabAccessToken() {
    return this.gitlabAccessToken;
  }

  /**
   * gitlab_access_token */
  public void setGitlabAccessToken(String gitlabAccessToken) {
    this.gitlabAccessToken = gitlabAccessToken;
  }

  /**
   * 代码库地址 */
  public String getScmUrl() {
    return this.scmUrl;
  }

  /**
   * 代码库地址 */
  public void setScmUrl(String scmUrl) {
    this.scmUrl = scmUrl;
  }
}
