//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.BatchdeleteClusterNodeResponse;
import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 批量删除集群节点
 */
public class BatchdeleteClusterNodeRequest extends AntCloudProviderRequest<BatchdeleteClusterNodeResponse> {
  private Boolean destroyComputer;

  @NotNull
  private List<String> nodes;

  @NotNull
  private String operatorName;

  private String password;

  @NotNull
  private String workspace;

  public BatchdeleteClusterNodeRequest() {
    super("antcloud.aks.cluster.node.batchdelete", "1.0", "Java-SDK-20190814");
  }

  /**
   * 删除机器, true
   * 清楚机器环境，false。清楚机器环境时必须重置机器password，需填写paasword选项
   * 清楚机器环境和删除机器选项二选一 */
  public Boolean getDestroyComputer() {
    return this.destroyComputer;
  }

  /**
   * 删除机器, true
   * 清楚机器环境，false。清楚机器环境时必须重置机器password，需填写paasword选项
   * 清楚机器环境和删除机器选项二选一 */
  public void setDestroyComputer(Boolean destroyComputer) {
    this.destroyComputer = destroyComputer;
  }

  /**
   * 集群节点名称列表 */
  public List<String> getNodes() {
    return this.nodes;
  }

  /**
   * 集群节点名称列表 */
  public void setNodes(List<String> nodes) {
    this.nodes = nodes;
  }

  /**
   * 操作人 */
  public String getOperatorName() {
    return this.operatorName;
  }

  /**
   * 操作人 */
  public void setOperatorName(String operatorName) {
    this.operatorName = operatorName;
  }

  /**
   * 若选择清楚机器环境，必须重置机器ECS password */
  public String getPassword() {
    return this.password;
  }

  /**
   * 若选择清楚机器环境，必须重置机器ECS password */
  public void setPassword(String password) {
    this.password = password;
  }

  /**
   * 工作空间名称 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 工作空间名称 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
