//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.request;

import cn.com.antcloud.api.antcloud.provider.AntCloudProviderRequest;
import cn.com.antcloud.api.provider.aks.v1_0_0.response.AddClusterNodeResponse;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 导入已有ECS到集群
 */
public class AddClusterNodeRequest extends AntCloudProviderRequest<AddClusterNodeResponse> {
  @NotNull
  private String cell;

  @NotNull
  private List<String> nodes;

  @NotNull
  private String operatorName;

  @NotNull
  private String workspace;

  public AddClusterNodeRequest() {
    super("antcloud.aks.cluster.node.add", "1.0", "Java-SDK-20190814");
  }

  /**
   * 部署单元名称 */
  public String getCell() {
    return this.cell;
  }

  /**
   * 部署单元名称 */
  public void setCell(String cell) {
    this.cell = cell;
  }

  /**
   * k8s node name， node paas ids */
  public List<String> getNodes() {
    return this.nodes;
  }

  /**
   * k8s node name， node paas ids */
  public void setNodes(List<String> nodes) {
    this.nodes = nodes;
  }

  /**
   * 操作人名称 */
  public String getOperatorName() {
    return this.operatorName;
  }

  /**
   * 操作人名称 */
  public void setOperatorName(String operatorName) {
    this.operatorName = operatorName;
  }

  /**
   * 工作空间名称 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 工作空间名称 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
