//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Boolean;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 数据卷配置 */
public class Volume {
  @NotNull
  private String mountPath;

  private String pathInVolume;

  private Boolean readOnly;

  private String volumeRefName;

  @NotNull
  private String volumeType;

  /**
   * 容器目录 */
  public String getMountPath() {
    return this.mountPath;
  }

  /**
   * 容器目录 */
  public void setMountPath(String mountPath) {
    this.mountPath = mountPath;
  }

  /**
   * 主机目录，当volume_type为HOST时必填 */
  public String getPathInVolume() {
    return this.pathInVolume;
  }

  /**
   * 主机目录，当volume_type为HOST时必填 */
  public void setPathInVolume(String pathInVolume) {
    this.pathInVolume = pathInVolume;
  }

  /**
   * 是否只读 */
  public Boolean getReadOnly() {
    return this.readOnly;
  }

  /**
   * 是否只读 */
  public void setReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
  }

  /**
   * 当volume_type为CONFIGMAP或者SECRET时必填 */
  public String getVolumeRefName() {
    return this.volumeRefName;
  }

  /**
   * 当volume_type为CONFIGMAP或者SECRET时必填 */
  public void setVolumeRefName(String volumeRefName) {
    this.volumeRefName = volumeRefName;
  }

  /**
   * 数据卷类型，取值
   * LOCAL_STORAGE：主机挂载，
   * CONFIGMAP：配置项，
   * SECRET：保密字典 */
  public String getVolumeType() {
    return this.volumeType;
  }

  /**
   * 数据卷类型，取值
   * LOCAL_STORAGE：主机挂载，
   * CONFIGMAP：配置项，
   * SECRET：保密字典 */
  public void setVolumeType(String volumeType) {
    this.volumeType = volumeType;
  }
}
