//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * Mesh 流量规则 */
public class TrafficRule {
  @NotNull
  private Long deployingReplicas;

  @NotNull
  private String deployingRevision;

  @NotNull
  private Long runtimeReplicas;

  @NotNull
  private String runtimeRevision;

  @NotNull
  private String targetServiceName;

  @NotNull
  private Long trafficWeight;

  /**
   * 正在部署的版本期望的副本数 */
  public Long getDeployingReplicas() {
    return this.deployingReplicas;
  }

  /**
   * 正在部署的版本期望的副本数 */
  public void setDeployingReplicas(Long deployingReplicas) {
    this.deployingReplicas = deployingReplicas;
  }

  /**
   * 当前正在发布的版本 */
  public String getDeployingRevision() {
    return this.deployingRevision;
  }

  /**
   * 当前正在发布的版本 */
  public void setDeployingRevision(String deployingRevision) {
    this.deployingRevision = deployingRevision;
  }

  /**
   * 当前副本数 */
  public Long getRuntimeReplicas() {
    return this.runtimeReplicas;
  }

  /**
   * 当前副本数 */
  public void setRuntimeReplicas(Long runtimeReplicas) {
    this.runtimeReplicas = runtimeReplicas;
  }

  /**
   * 当前运行版本 */
  public String getRuntimeRevision() {
    return this.runtimeRevision;
  }

  /**
   * 当前运行版本 */
  public void setRuntimeRevision(String runtimeRevision) {
    this.runtimeRevision = runtimeRevision;
  }

  /**
   * mesh 引流的目标 service */
  public String getTargetServiceName() {
    return this.targetServiceName;
  }

  /**
   * mesh 引流的目标 service */
  public void setTargetServiceName(String targetServiceName) {
    this.targetServiceName = targetServiceName;
  }

  /**
   * 流量权重 */
  public Long getTrafficWeight() {
    return this.trafficWeight;
  }

  /**
   * 流量权重 */
  public void setTrafficWeight(Long trafficWeight) {
    this.trafficWeight = trafficWeight;
  }
}
