//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 服务端口映射 */
public class ServicePortMapping {
  @NotNull
  private Long port;

  @NotNull
  private String protocol;

  @NotNull
  private Long targetPort;

  /**
   * 服务暴露端口 */
  public Long getPort() {
    return this.port;
  }

  /**
   * 服务暴露端口 */
  public void setPort(Long port) {
    this.port = port;
  }

  /**
   * 协议 */
  public String getProtocol() {
    return this.protocol;
  }

  /**
   * 协议 */
  public void setProtocol(String protocol) {
    this.protocol = protocol;
  }

  /**
   * 容器端口 */
  public Long getTargetPort() {
    return this.targetPort;
  }

  /**
   * 容器端口 */
  public void setTargetPort(Long targetPort) {
    this.targetPort = targetPort;
  }
}
