//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 公网负载均衡访问配置 */
public class PublicLoadBalancerService {
  @NotNull
  private List<Listener> listeners;

  @NotNull
  private String name;

  @NotNull
  private String slbIaasId;

  @NotNull
  private String slbName;

  /**
   * 端口监听 */
  public List<Listener> getListeners() {
    return this.listeners;
  }

  /**
   * 端口监听 */
  public void setListeners(List<Listener> listeners) {
    this.listeners = listeners;
  }

  /**
   * 服务名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 服务名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 公网 SLB iaas id */
  public String getSlbIaasId() {
    return this.slbIaasId;
  }

  /**
   * 公网 SLB iaas id */
  public void setSlbIaasId(String slbIaasId) {
    this.slbIaasId = slbIaasId;
  }

  /**
   * 公网 SLB 名称 */
  public String getSlbName() {
    return this.slbName;
  }

  /**
   * 公网 SLB 名称 */
  public void setSlbName(String slbName) {
    this.slbName = slbName;
  }
}
