//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * PodStatus */
public class PodStatus {
  @NotNull
  private List<PodCondition> conditions;

  @NotNull
  private List<ContainerStatus> containerStatuses;

  @NotNull
  private String hostIp;

  @NotNull
  private String phase;

  @NotNull
  private String podIp;

  @NotNull
  private String startTime;

  /**
   * conditions */
  public List<PodCondition> getConditions() {
    return this.conditions;
  }

  /**
   * conditions */
  public void setConditions(List<PodCondition> conditions) {
    this.conditions = conditions;
  }

  /**
   * pod下container的状态
   */
  public List<ContainerStatus> getContainerStatuses() {
    return this.containerStatuses;
  }

  /**
   * pod下container的状态
   */
  public void setContainerStatuses(List<ContainerStatus> containerStatuses) {
    this.containerStatuses = containerStatuses;
  }

  /**
   * host ip */
  public String getHostIp() {
    return this.hostIp;
  }

  /**
   * host ip */
  public void setHostIp(String hostIp) {
    this.hostIp = hostIp;
  }

  /**
   * pod运行阶段
   */
  public String getPhase() {
    return this.phase;
  }

  /**
   * pod运行阶段
   */
  public void setPhase(String phase) {
    this.phase = phase;
  }

  /**
   * pod ip */
  public String getPodIp() {
    return this.podIp;
  }

  /**
   * pod ip */
  public void setPodIp(String podIp) {
    this.podIp = podIp;
  }

  /**
   * pod的创建时间
   */
  public String getStartTime() {
    return this.startTime;
  }

  /**
   * pod的创建时间
   */
  public void setStartTime(String startTime) {
    this.startTime = startTime;
  }
}
