//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * aks中pod对象 */
public class Pod {
  private List<Annotation> annotations;

  @NotNull
  private String cellId;

  private List<Label> labels;

  @NotNull
  private String name;

  @NotNull
  private String namespace;

  @NotNull
  private PodSpec spec;

  @NotNull
  private PodStatus status;

  @NotNull
  private String uid;

  /**
   * annotations */
  public List<Annotation> getAnnotations() {
    return this.annotations;
  }

  /**
   * annotations */
  public void setAnnotations(List<Annotation> annotations) {
    this.annotations = annotations;
  }

  /**
   * cell_id */
  public String getCellId() {
    return this.cellId;
  }

  /**
   * cell_id */
  public void setCellId(String cellId) {
    this.cellId = cellId;
  }

  /**
   * labels */
  public List<Label> getLabels() {
    return this.labels;
  }

  /**
   * labels */
  public void setLabels(List<Label> labels) {
    this.labels = labels;
  }

  /**
   * pod​名称 */
  public String getName() {
    return this.name;
  }

  /**
   * pod​名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * namespace */
  public String getNamespace() {
    return this.namespace;
  }

  /**
   * namespace */
  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }

  /**
   * podspec */
  public PodSpec getSpec() {
    return this.spec;
  }

  /**
   * podspec */
  public void setSpec(PodSpec spec) {
    this.spec = spec;
  }

  /**
   * podstatus */
  public PodStatus getStatus() {
    return this.status;
  }

  /**
   * podstatus */
  public void setStatus(PodStatus status) {
    this.status = status;
  }

  /**
   * poduid */
  public String getUid() {
    return this.uid;
  }

  /**
   * poduid */
  public void setUid(String uid) {
    this.uid = uid;
  }
}
