//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 一组执行运维操作的容器服务实例，同一个组中的容器服务实例将并行执行操作 */
public class OpsContainerServiceGroup {
  @NotNull
  private List<OpsContainerService> containerServices;

  /**
   * 此运维容器服务实例组中包含的容器服务实例列表 */
  public List<OpsContainerService> getContainerServices() {
    return this.containerServices;
  }

  /**
   * 此运维容器服务实例组中包含的容器服务实例列表 */
  public void setContainerServices(List<OpsContainerService> containerServices) {
    this.containerServices = containerServices;
  }
}
