//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 一个运维操作链。一个操作链中包含一个顺序的运维容器实例组列表，这些运维组将依次串行的执行运维操作。不同的操作链将并行执行 */
public class OpsContainerServiceChain {
  @NotNull
  private List<OpsContainerServiceGroup> groups;

  /**
   * 此运维链中包含的容器服务实例组列表
   */
  public List<OpsContainerServiceGroup> getGroups() {
    return this.groups;
  }

  /**
   * 此运维链中包含的容器服务实例组列表
   */
  public void setGroups(List<OpsContainerServiceGroup> groups) {
    this.groups = groups;
  }
}
