//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.String;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 运维操作中的容器服务实例 */
public class OpsContainerService {
  private Date finishedTime;

  private String isRollbacked;

  private List<Label> labels;

  @NotNull
  private String name;

  private List<OpsPod> opsPods;

  private List<OpsDeploymentTask> postDeploymentTasks;

  private List<OpsDeploymentTask> preDeploymentTasks;

  @NotNull
  private String revision;

  private Date startedTime;

  @NotNull
  private String status;

  /**
   * 发布结束时间 */
  public Date getFinishedTime() {
    return this.finishedTime;
  }

  /**
   * 发布结束时间 */
  public void setFinishedTime(Date finishedTime) {
    this.finishedTime = finishedTime;
  }

  /**
   * 是否回滚 */
  public String getIsRollbacked() {
    return this.isRollbacked;
  }

  /**
   * 是否回滚 */
  public void setIsRollbacked(String isRollbacked) {
    this.isRollbacked = isRollbacked;
  }

  /**
   * 标签信息 */
  public List<Label> getLabels() {
    return this.labels;
  }

  /**
   * 标签信息 */
  public void setLabels(List<Label> labels) {
    this.labels = labels;
  }

  /**
   * 容器服务名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 容器服务名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 该容器服务中包含的pod */
  public List<OpsPod> getOpsPods() {
    return this.opsPods;
  }

  /**
   * 该容器服务中包含的pod */
  public void setOpsPods(List<OpsPod> opsPods) {
    this.opsPods = opsPods;
  }

  /**
   * 发布部署后置任务 */
  public List<OpsDeploymentTask> getPostDeploymentTasks() {
    return this.postDeploymentTasks;
  }

  /**
   * 发布部署后置任务 */
  public void setPostDeploymentTasks(List<OpsDeploymentTask> postDeploymentTasks) {
    this.postDeploymentTasks = postDeploymentTasks;
  }

  /**
   * 发布部署前置任务 */
  public List<OpsDeploymentTask> getPreDeploymentTasks() {
    return this.preDeploymentTasks;
  }

  /**
   * 发布部署前置任务 */
  public void setPreDeploymentTasks(List<OpsDeploymentTask> preDeploymentTasks) {
    this.preDeploymentTasks = preDeploymentTasks;
  }

  /**
   * 容器服务当前的发布版本 */
  public String getRevision() {
    return this.revision;
  }

  /**
   * 容器服务当前的发布版本 */
  public void setRevision(String revision) {
    this.revision = revision;
  }

  /**
   * 发布开始时间 */
  public Date getStartedTime() {
    return this.startedTime;
  }

  /**
   * 发布开始时间 */
  public void setStartedTime(Date startedTime) {
    this.startedTime = startedTime;
  }

  /**
   * 容器服务当前运维状态。取值列表：INITING：初始化中；INIT_FAILED：初始化失败；INITED：初始化完成；EXECUTING：执行中；SUCCESS：执行成功；FAILED：执行失败；ROLLBACKED：已回滚；CANCELED：已取消 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 容器服务当前运维状态。取值列表：INITING：初始化中；INIT_FAILED：初始化失败；INITED：初始化完成；EXECUTING：执行中；SUCCESS：执行成功；FAILED：执行失败；ROLLBACKED：已回滚；CANCELED：已取消 */
  public void setStatus(String status) {
    this.status = status;
  }
}
