//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * ECS节点创建信息 */
public class NodeCreationInfo {
  @NotNull
  private Long amount;

  @NotNull
  private String cell;

  @NotNull
  private String computerSpecId;

  private Long dataDiskSize;

  private String dataDiskSpecId;

  @NotNull
  private String namePrefix;

  @NotNull
  private String password;

  @NotNull
  private String securityGroupId;

  @NotNull
  private Long systemDiskSize;

  @NotNull
  private String systemDiskSpecId;

  @NotNull
  private String vswicthId;

  @NotNull
  private String zoneId;

  /**
   * 新建的ECS节点数目 */
  public Long getAmount() {
    return this.amount;
  }

  /**
   * 新建的ECS节点数目 */
  public void setAmount(Long amount) {
    this.amount = amount;
  }

  /**
   * 部署单元名称 */
  public String getCell() {
    return this.cell;
  }

  /**
   * 部署单元名称 */
  public void setCell(String cell) {
    this.cell = cell;
  }

  /**
   * 新建ECS节点的规格id */
  public String getComputerSpecId() {
    return this.computerSpecId;
  }

  /**
   * 新建ECS节点的规格id */
  public void setComputerSpecId(String computerSpecId) {
    this.computerSpecId = computerSpecId;
  }

  /**
   * ECS数据盘大小，单位GB */
  public Long getDataDiskSize() {
    return this.dataDiskSize;
  }

  /**
   * ECS数据盘大小，单位GB */
  public void setDataDiskSize(Long dataDiskSize) {
    this.dataDiskSize = dataDiskSize;
  }

  /**
   * 新建ECS的数据盘类型，高效云盘,ssd等 */
  public String getDataDiskSpecId() {
    return this.dataDiskSpecId;
  }

  /**
   * 新建ECS的数据盘类型，高效云盘,ssd等 */
  public void setDataDiskSpecId(String dataDiskSpecId) {
    this.dataDiskSpecId = dataDiskSpecId;
  }

  /**
   * 集群创建的ECS名称前缀 */
  public String getNamePrefix() {
    return this.namePrefix;
  }

  /**
   * 集群创建的ECS名称前缀 */
  public void setNamePrefix(String namePrefix) {
    this.namePrefix = namePrefix;
  }

  /**
   * ECS密码 */
  public String getPassword() {
    return this.password;
  }

  /**
   * ECS密码 */
  public void setPassword(String password) {
    this.password = password;
  }

  /**
   * 新建ECS节点所关联的安全组id */
  public String getSecurityGroupId() {
    return this.securityGroupId;
  }

  /**
   * 新建ECS节点所关联的安全组id */
  public void setSecurityGroupId(String securityGroupId) {
    this.securityGroupId = securityGroupId;
  }

  /**
   * 系统磁盘大小，单位GB，建议100-500，不能超过500G */
  public Long getSystemDiskSize() {
    return this.systemDiskSize;
  }

  /**
   * 系统磁盘大小，单位GB，建议100-500，不能超过500G */
  public void setSystemDiskSize(Long systemDiskSize) {
    this.systemDiskSize = systemDiskSize;
  }

  /**
   * 系统磁盘类型，高效云盘,ssd等 */
  public String getSystemDiskSpecId() {
    return this.systemDiskSpecId;
  }

  /**
   * 系统磁盘类型，高效云盘,ssd等 */
  public void setSystemDiskSpecId(String systemDiskSpecId) {
    this.systemDiskSpecId = systemDiskSpecId;
  }

  /**
   * VPC网络下新建ECS关联的VswitchId */
  public String getVswicthId() {
    return this.vswicthId;
  }

  /**
   * VPC网络下新建ECS关联的VswitchId */
  public void setVswicthId(String vswicthId) {
    this.vswicthId = vswicthId;
  }

  /**
   * 新建ECS节点所属的可用区id */
  public String getZoneId() {
    return this.zoneId;
  }

  /**
   * 新建ECS节点所属的可用区id */
  public void setZoneId(String zoneId) {
    this.zoneId = zoneId;
  }
}
