//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 命名空间 */
public class Namespace {
  private List<Annotation> annotations;

  private String clusterId;

  private List<Label> labels;

  @NotNull
  private String name;

  private String regionId;

  @NotNull
  private String state;

  private String tenantId;

  private String workspaceId;

  /**
   * namespace annotations */
  public List<Annotation> getAnnotations() {
    return this.annotations;
  }

  /**
   * namespace annotations */
  public void setAnnotations(List<Annotation> annotations) {
    this.annotations = annotations;
  }

  /**
   * 所属集群id */
  public String getClusterId() {
    return this.clusterId;
  }

  /**
   * 所属集群id */
  public void setClusterId(String clusterId) {
    this.clusterId = clusterId;
  }

  /**
   * namespace labels */
  public List<Label> getLabels() {
    return this.labels;
  }

  /**
   * namespace labels */
  public void setLabels(List<Label> labels) {
    this.labels = labels;
  }

  /**
   * Namespace名称 */
  public String getName() {
    return this.name;
  }

  /**
   * Namespace名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * Region id */
  public String getRegionId() {
    return this.regionId;
  }

  /**
   * Region id */
  public void setRegionId(String regionId) {
    this.regionId = regionId;
  }

  /**
   * Namespace状态 */
  public String getState() {
    return this.state;
  }

  /**
   * Namespace状态 */
  public void setState(String state) {
    this.state = state;
  }

  /**
   * tenant id */
  public String getTenantId() {
    return this.tenantId;
  }

  /**
   * tenant id */
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  /**
   * workspaceId */
  public String getWorkspaceId() {
    return this.workspaceId;
  }

  /**
   * workspaceId */
  public void setWorkspaceId(String workspaceId) {
    this.workspaceId = workspaceId;
  }
}
