//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Long;
import javax.validation.constraints.NotNull;

/**
 * 容器健康检查-LivenessProbe */
public class LivenessProbe {
  private ExecAction execAction;

  @NotNull
  private Long failureThreshold;

  private HttpGetAction httpGetAction;

  @NotNull
  private Long initialDelaySeconds;

  @NotNull
  private Long periodSeconds;

  @NotNull
  private Long successThreshold;

  private TcpSocketAction tcpSocketAction;

  @NotNull
  private Long timeoutSeconds;

  /**
   * 命令行方式的健康监测配置 */
  public ExecAction getExecAction() {
    return this.execAction;
  }

  /**
   * 命令行方式的健康监测配置 */
  public void setExecAction(ExecAction execAction) {
    this.execAction = execAction;
  }

  /**
   * 不健康阈值 */
  public Long getFailureThreshold() {
    return this.failureThreshold;
  }

  /**
   * 不健康阈值 */
  public void setFailureThreshold(Long failureThreshold) {
    this.failureThreshold = failureThreshold;
  }

  /**
   * http方式的健康监测配置 */
  public HttpGetAction getHttpGetAction() {
    return this.httpGetAction;
  }

  /**
   * http方式的健康监测配置 */
  public void setHttpGetAction(HttpGetAction httpGetAction) {
    this.httpGetAction = httpGetAction;
  }

  /**
   * 首次检查延时 */
  public Long getInitialDelaySeconds() {
    return this.initialDelaySeconds;
  }

  /**
   * 首次检查延时 */
  public void setInitialDelaySeconds(Long initialDelaySeconds) {
    this.initialDelaySeconds = initialDelaySeconds;
  }

  /**
   * 检查间隔 */
  public Long getPeriodSeconds() {
    return this.periodSeconds;
  }

  /**
   * 检查间隔 */
  public void setPeriodSeconds(Long periodSeconds) {
    this.periodSeconds = periodSeconds;
  }

  /**
   * 健康阈值 */
  public Long getSuccessThreshold() {
    return this.successThreshold;
  }

  /**
   * 健康阈值 */
  public void setSuccessThreshold(Long successThreshold) {
    this.successThreshold = successThreshold;
  }

  /**
   * tcp方式的健康监测配置 */
  public TcpSocketAction getTcpSocketAction() {
    return this.tcpSocketAction;
  }

  /**
   * tcp方式的健康监测配置 */
  public void setTcpSocketAction(TcpSocketAction tcpSocketAction) {
    this.tcpSocketAction = tcpSocketAction;
  }

  /**
   * 检查超时 */
  public Long getTimeoutSeconds() {
    return this.timeoutSeconds;
  }

  /**
   * 检查超时 */
  public void setTimeoutSeconds(Long timeoutSeconds) {
    this.timeoutSeconds = timeoutSeconds;
  }
}
