//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * SLB 端口监听 */
public class Listener {
  @NotNull
  private Long backendPort;

  private String certificateId;

  private Boolean enableHealthCheck;

  @NotNull
  private Long frontPort;

  private Long healthyThreshold;

  private String healthCheckDomain;

  private String healthCheckUri;

  private Long interval;

  @NotNull
  private String protocol;

  private Long timeout;

  @NotNull
  private String transferStrategy;

  private Long unhealthyThreshold;

  /**
   * 后端端口 */
  public Long getBackendPort() {
    return this.backendPort;
  }

  /**
   * 后端端口 */
  public void setBackendPort(Long backendPort) {
    this.backendPort = backendPort;
  }

  /**
   * 证书ID，HTTPS协议下必填 */
  public String getCertificateId() {
    return this.certificateId;
  }

  /**
   * 证书ID，HTTPS协议下必填 */
  public void setCertificateId(String certificateId) {
    this.certificateId = certificateId;
  }

  /**
   * 是否开启健康检查，默认 false */
  public Boolean getEnableHealthCheck() {
    return this.enableHealthCheck;
  }

  /**
   * 是否开启健康检查，默认 false */
  public void setEnableHealthCheck(Boolean enableHealthCheck) {
    this.enableHealthCheck = enableHealthCheck;
  }

  /**
   * 服务端口 */
  public Long getFrontPort() {
    return this.frontPort;
  }

  /**
   * 服务端口 */
  public void setFrontPort(Long frontPort) {
    this.frontPort = frontPort;
  }

  /**
   * 健康阈值 */
  public Long getHealthyThreshold() {
    return this.healthyThreshold;
  }

  /**
   * 健康阈值 */
  public void setHealthyThreshold(Long healthyThreshold) {
    this.healthyThreshold = healthyThreshold;
  }

  /**
   * healthcheck.alipay.com */
  public String getHealthCheckDomain() {
    return this.healthCheckDomain;
  }

  /**
   * healthcheck.alipay.com */
  public void setHealthCheckDomain(String healthCheckDomain) {
    this.healthCheckDomain = healthCheckDomain;
  }

  /**
   * 健康检查路径 */
  public String getHealthCheckUri() {
    return this.healthCheckUri;
  }

  /**
   * 健康检查路径 */
  public void setHealthCheckUri(String healthCheckUri) {
    this.healthCheckUri = healthCheckUri;
  }

  /**
   * 健康检查间隔 */
  public Long getInterval() {
    return this.interval;
  }

  /**
   * 健康检查间隔 */
  public void setInterval(Long interval) {
    this.interval = interval;
  }

  /**
   * 协议 */
  public String getProtocol() {
    return this.protocol;
  }

  /**
   * 协议 */
  public void setProtocol(String protocol) {
    this.protocol = protocol;
  }

  /**
   * 健康检查超时时间 (s) */
  public Long getTimeout() {
    return this.timeout;
  }

  /**
   * 健康检查超时时间 (s) */
  public void setTimeout(Long timeout) {
    this.timeout = timeout;
  }

  /**
   * 转发规则。
   * WRR：按权重，WLC：按权重并且最小连接数，RR：轮询 */
  public String getTransferStrategy() {
    return this.transferStrategy;
  }

  /**
   * 转发规则。
   * WRR：按权重，WLC：按权重并且最小连接数，RR：轮询 */
  public void setTransferStrategy(String transferStrategy) {
    this.transferStrategy = transferStrategy;
  }

  /**
   * 不健康阈值 */
  public Long getUnhealthyThreshold() {
    return this.unhealthyThreshold;
  }

  /**
   * 不健康阈值 */
  public void setUnhealthyThreshold(Long unhealthyThreshold) {
    this.unhealthyThreshold = unhealthyThreshold;
  }
}
