//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

/**
 * 容器生命周期hook */
public class LifecycleHook {
  private ExecAction postStartExec;

  private HttpGetAction postStartHttp;

  private TcpSocketAction postStartTcp;

  private ExecAction preStopExec;

  private HttpGetAction preStopHttp;

  private TcpSocketAction preStopTcp;

  /**
   * 启动后执行命令 */
  public ExecAction getPostStartExec() {
    return this.postStartExec;
  }

  /**
   * 启动后执行命令 */
  public void setPostStartExec(ExecAction postStartExec) {
    this.postStartExec = postStartExec;
  }

  /**
   * 启动后执行http get */
  public HttpGetAction getPostStartHttp() {
    return this.postStartHttp;
  }

  /**
   * 启动后执行http get */
  public void setPostStartHttp(HttpGetAction postStartHttp) {
    this.postStartHttp = postStartHttp;
  }

  /**
   * 启动后执行TCP请求 */
  public TcpSocketAction getPostStartTcp() {
    return this.postStartTcp;
  }

  /**
   * 启动后执行TCP请求 */
  public void setPostStartTcp(TcpSocketAction postStartTcp) {
    this.postStartTcp = postStartTcp;
  }

  /**
   * 停止前执行命令 */
  public ExecAction getPreStopExec() {
    return this.preStopExec;
  }

  /**
   * 停止前执行命令 */
  public void setPreStopExec(ExecAction preStopExec) {
    this.preStopExec = preStopExec;
  }

  /**
   * 停止前http get */
  public HttpGetAction getPreStopHttp() {
    return this.preStopHttp;
  }

  /**
   * 停止前http get */
  public void setPreStopHttp(HttpGetAction preStopHttp) {
    this.preStopHttp = preStopHttp;
  }

  /**
   * 停止前TCP请求 */
  public TcpSocketAction getPreStopTcp() {
    return this.preStopTcp;
  }

  /**
   * 停止前TCP请求 */
  public void setPreStopTcp(TcpSocketAction preStopTcp) {
    this.preStopTcp = preStopTcp;
  }
}
