//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * Kube事件 */
public class KubeEvent {
  @NotNull
  private Long count;

  @NotNull
  private String message;

  @NotNull
  private Date modifiedTime;

  @NotNull
  private String type;

  /**
   * 次数 */
  public Long getCount() {
    return this.count;
  }

  /**
   * 次数 */
  public void setCount(Long count) {
    this.count = count;
  }

  /**
   * 消息内容 */
  public String getMessage() {
    return this.message;
  }

  /**
   * 消息内容 */
  public void setMessage(String message) {
    this.message = message;
  }

  /**
   * 修改时间 */
  public Date getModifiedTime() {
    return this.modifiedTime;
  }

  /**
   * 修改时间 */
  public void setModifiedTime(Date modifiedTime) {
    this.modifiedTime = modifiedTime;
  }

  /**
   * 消息类型，取值范围 Normal, Warning, Error */
  public String getType() {
    return this.type;
  }

  /**
   * 消息类型，取值范围 Normal, Warning, Error */
  public void setType(String type) {
    this.type = type;
  }
}
