//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 镜像的project */
public class ImageProject {
  @NotNull
  private Date creationTime;

  @NotNull
  private Long currentUserRoleId;

  @NotNull
  private Boolean deleted;

  private ImageProjectMetadata metadata;

  @NotNull
  private String name;

  @NotNull
  private Long ownerId;

  private String ownerName;

  @NotNull
  private Long projectId;

  @NotNull
  private Long repoCount;

  private Boolean togglable;

  @NotNull
  private Date updateTime;

  /**
   * 创建时间 */
  public Date getCreationTime() {
    return this.creationTime;
  }

  /**
   * 创建时间 */
  public void setCreationTime(Date creationTime) {
    this.creationTime = creationTime;
  }

  /**
   * 用户角色 */
  public Long getCurrentUserRoleId() {
    return this.currentUserRoleId;
  }

  /**
   * 用户角色 */
  public void setCurrentUserRoleId(Long currentUserRoleId) {
    this.currentUserRoleId = currentUserRoleId;
  }

  /**
   * 是否已删除 */
  public Boolean getDeleted() {
    return this.deleted;
  }

  /**
   * 是否已删除 */
  public void setDeleted(Boolean deleted) {
    this.deleted = deleted;
  }

  /**
   * 元数据 */
  public ImageProjectMetadata getMetadata() {
    return this.metadata;
  }

  /**
   * 元数据 */
  public void setMetadata(ImageProjectMetadata metadata) {
    this.metadata = metadata;
  }

  /**
   * 镜像namespace名 */
  public String getName() {
    return this.name;
  }

  /**
   * 镜像namespace名 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * owner_id */
  public Long getOwnerId() {
    return this.ownerId;
  }

  /**
   * owner_id */
  public void setOwnerId(Long ownerId) {
    this.ownerId = ownerId;
  }

  /**
   * owner_name */
  public String getOwnerName() {
    return this.ownerName;
  }

  /**
   * owner_name */
  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }

  /**
   * project_id */
  public Long getProjectId() {
    return this.projectId;
  }

  /**
   * project_id */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * repo_count */
  public Long getRepoCount() {
    return this.repoCount;
  }

  /**
   * repo_count */
  public void setRepoCount(Long repoCount) {
    this.repoCount = repoCount;
  }

  /**
   * togglable */
  public Boolean getTogglable() {
    return this.togglable;
  }

  /**
   * togglable */
  public void setTogglable(Boolean togglable) {
    this.togglable = togglable;
  }

  /**
   * update_time */
  public Date getUpdateTime() {
    return this.updateTime;
  }

  /**
   * update_time */
  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }
}
