//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Long;
import javax.validation.constraints.NotNull;

/**
 * 健康检查探针 */
public class HealthCheckProbe {
  private ExecAction execAction;

  @NotNull
  private Long failureThreshold;

  private HttpGetAction httpGetAction;

  @NotNull
  private Long initialDelaySeconds;

  @NotNull
  private Long periodSeconds;

  @NotNull
  private Long successThreshold;

  private TcpSocketAction tcpSocketAction;

  @NotNull
  private Long timeOutSeconds;

  /**
   * 基于命令行类型的探针必填 */
  public ExecAction getExecAction() {
    return this.execAction;
  }

  /**
   * 基于命令行类型的探针必填 */
  public void setExecAction(ExecAction execAction) {
    this.execAction = execAction;
  }

  /**
   * 探针运行失败阈值 */
  public Long getFailureThreshold() {
    return this.failureThreshold;
  }

  /**
   * 探针运行失败阈值 */
  public void setFailureThreshold(Long failureThreshold) {
    this.failureThreshold = failureThreshold;
  }

  /**
   * 基于HTTP GET请求的探针必填 */
  public HttpGetAction getHttpGetAction() {
    return this.httpGetAction;
  }

  /**
   * 基于HTTP GET请求的探针必填 */
  public void setHttpGetAction(HttpGetAction httpGetAction) {
    this.httpGetAction = httpGetAction;
  }

  /**
   * 探针初始运行延迟时间 */
  public Long getInitialDelaySeconds() {
    return this.initialDelaySeconds;
  }

  /**
   * 探针初始运行延迟时间 */
  public void setInitialDelaySeconds(Long initialDelaySeconds) {
    this.initialDelaySeconds = initialDelaySeconds;
  }

  /**
   * 探针运行间隔时间 */
  public Long getPeriodSeconds() {
    return this.periodSeconds;
  }

  /**
   * 探针运行间隔时间 */
  public void setPeriodSeconds(Long periodSeconds) {
    this.periodSeconds = periodSeconds;
  }

  /**
   * 探针运行成功阈值 */
  public Long getSuccessThreshold() {
    return this.successThreshold;
  }

  /**
   * 探针运行成功阈值 */
  public void setSuccessThreshold(Long successThreshold) {
    this.successThreshold = successThreshold;
  }

  /**
   * 基于TCP连接的探针必填 */
  public TcpSocketAction getTcpSocketAction() {
    return this.tcpSocketAction;
  }

  /**
   * 基于TCP连接的探针必填 */
  public void setTcpSocketAction(TcpSocketAction tcpSocketAction) {
    this.tcpSocketAction = tcpSocketAction;
  }

  /**
   * 探针运行超时时间 */
  public Long getTimeOutSeconds() {
    return this.timeOutSeconds;
  }

  /**
   * 探针运行超时时间 */
  public void setTimeOutSeconds(Long timeOutSeconds) {
    this.timeOutSeconds = timeOutSeconds;
  }
}
