//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Long;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/**
 * 保存弹性配置中的固定副本数相关配置 */
public class FixedConfig {
  @NotNull
  @Min(0)
  private Long replicas;

  /**
   * 当前版本的固定副本数 */
  public Long getReplicas() {
    return this.replicas;
  }

  /**
   * 当前版本的固定副本数 */
  public void setReplicas(Long replicas) {
    this.replicas = replicas;
  }
}
