//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 环境变量 */
public class Env {
  private String envRefKey;

  @NotNull
  private String key;

  private String name;

  @NotNull
  private String source;

  @NotNull
  private String value;

  /**
   * 当source为CONFIGMAP/SECRET时必填 */
  public String getEnvRefKey() {
    return this.envRefKey;
  }

  /**
   * 当source为CONFIGMAP/SECRET时必填 */
  public void setEnvRefKey(String envRefKey) {
    this.envRefKey = envRefKey;
  }

  /**
   * 环境变量key */
  public String getKey() {
    return this.key;
  }

  /**
   * 环境变量key */
  public void setKey(String key) {
    this.key = key;
  }

  /**
   * 当source为CONFIGMAP/SECRET时必填 */
  public String getName() {
    return this.name;
  }

  /**
   * 当source为CONFIGMAP/SECRET时必填 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * env来源，可选：
   * MANUAL：手动输入
   * CONFIGMAP：配置项
   * SECRET：保密字典 */
  public String getSource() {
    return this.source;
  }

  /**
   * env来源，可选：
   * MANUAL：手动输入
   * CONFIGMAP：配置项
   * SECRET：保密字典 */
  public void setSource(String source) {
    this.source = source;
  }

  /**
   * 环境变量value */
  public String getValue() {
    return this.value;
  }

  /**
   * 环境变量value */
  public void setValue(String value) {
    this.value = value;
  }
}
