//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 部署策略配置 */
public class DeployConfig {
  @NotNull
  private List<String> cells;

  private Long groupCount;

  private String groupStrategy;

  private Long maxGroupCapacity;

  private Boolean needBeta;

  private Boolean needConfirm;

  private Long replicas;

  private String scalePolicy;

  private String spreadStrategy;

  private String upgradeStrategy;

  /**
   * 部署单元 */
  public List<String> getCells() {
    return this.cells;
  }

  /**
   * 部署单元 */
  public void setCells(List<String> cells) {
    this.cells = cells;
  }

  /**
   * 发布分组数，默认 3 */
  public Long getGroupCount() {
    return this.groupCount;
  }

  /**
   * 发布分组数，默认 3 */
  public void setGroupCount(Long groupCount) {
    this.groupCount = groupCount;
  }

  /**
   * 默认快速分组，目前仅支持 QUICK */
  public String getGroupStrategy() {
    return this.groupStrategy;
  }

  /**
   * 默认快速分组，目前仅支持 QUICK */
  public void setGroupStrategy(String groupStrategy) {
    this.groupStrategy = groupStrategy;
  }

  /**
   * 默认 20 */
  public Long getMaxGroupCapacity() {
    return this.maxGroupCapacity;
  }

  /**
   * 默认 20 */
  public void setMaxGroupCapacity(Long maxGroupCapacity) {
    this.maxGroupCapacity = maxGroupCapacity;
  }

  /**
   * 是否需要beta分组，默认 true */
  public Boolean getNeedBeta() {
    return this.needBeta;
  }

  /**
   * 是否需要beta分组，默认 true */
  public void setNeedBeta(Boolean needBeta) {
    this.needBeta = needBeta;
  }

  /**
   * 是否需要分组确认，默认 true */
  public Boolean getNeedConfirm() {
    return this.needConfirm;
  }

  /**
   * 是否需要分组确认，默认 true */
  public void setNeedConfirm(Boolean needConfirm) {
    this.needConfirm = needConfirm;
  }

  /**
   * 副本数 */
  public Long getReplicas() {
    return this.replicas;
  }

  /**
   * 副本数 */
  public void setReplicas(Long replicas) {
    this.replicas = replicas;
  }

  /**
   * 扩缩容策略，默认 ALWAYS，即改变 replicas 会立即触发扩缩容 */
  public String getScalePolicy() {
    return this.scalePolicy;
  }

  /**
   * 扩缩容策略，默认 ALWAYS，即改变 replicas 会立即触发扩缩容 */
  public void setScalePolicy(String scalePolicy) {
    this.scalePolicy = scalePolicy;
  }

  /**
   * pod 分布策略，默认 ANY，即可任意分布于所选的 cell 中 */
  public String getSpreadStrategy() {
    return this.spreadStrategy;
  }

  /**
   * pod 分布策略，默认 ANY，即可任意分布于所选的 cell 中 */
  public void setSpreadStrategy(String spreadStrategy) {
    this.spreadStrategy = spreadStrategy;
  }

  /**
   * 默认 InPlace，即原地升级模式 */
  public String getUpgradeStrategy() {
    return this.upgradeStrategy;
  }

  /**
   * 默认 InPlace，即原地升级模式 */
  public void setUpgradeStrategy(String upgradeStrategy) {
    this.upgradeStrategy = upgradeStrategy;
  }
}
