//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 容器配置 */
public class ContainerSpec {
  @NotNull
  private String cpuLimit;

  @NotNull
  private String cpuRequest;

  private List<String> entryPoints;

  private List<Env> envVars;

  private HealthCheckConfig healthCheckConfig;

  @NotNull
  private String image;

  private String imageBuildName;

  @NotNull
  private String imageSource;

  private Boolean isBizMonitorSidecar;

  private Boolean isMeshSidecar;

  private LifecycleHook lifecycleHook;

  private List<LogConfig> logConfigs;

  @NotNull
  private String memoryLimit;

  @NotNull
  private String memoryRequest;

  @NotNull
  private String name;

  private String pullSecret;

  @NotNull
  private String restartPolicy;

  @NotNull
  private String type;

  private List<Volume> volumeMounts;

  /**
   * 最大CPU限制，格式 1/1m */
  public String getCpuLimit() {
    return this.cpuLimit;
  }

  /**
   * 最大CPU限制，格式 1/1m */
  public void setCpuLimit(String cpuLimit) {
    this.cpuLimit = cpuLimit;
  }

  /**
   * 最少需要的CPU核数，格式 1/1m */
  public String getCpuRequest() {
    return this.cpuRequest;
  }

  /**
   * 最少需要的CPU核数，格式 1/1m */
  public void setCpuRequest(String cpuRequest) {
    this.cpuRequest = cpuRequest;
  }

  /**
   * 启动命令 */
  public List<String> getEntryPoints() {
    return this.entryPoints;
  }

  /**
   * 启动命令 */
  public void setEntryPoints(List<String> entryPoints) {
    this.entryPoints = entryPoints;
  }

  /**
   * 环境变量 */
  public List<Env> getEnvVars() {
    return this.envVars;
  }

  /**
   * 环境变量 */
  public void setEnvVars(List<Env> envVars) {
    this.envVars = envVars;
  }

  /**
   * 健康检查配置 */
  public HealthCheckConfig getHealthCheckConfig() {
    return this.healthCheckConfig;
  }

  /**
   * 健康检查配置 */
  public void setHealthCheckConfig(HealthCheckConfig healthCheckConfig) {
    this.healthCheckConfig = healthCheckConfig;
  }

  /**
   * 地址，格式形如 repository:tag */
  public String getImage() {
    return this.image;
  }

  /**
   * 地址，格式形如 repository:tag */
  public void setImage(String image) {
    this.image = image;
  }

  /**
   * 镜像构建名 */
  public String getImageBuildName() {
    return this.imageBuildName;
  }

  /**
   * 镜像构建名 */
  public void setImageBuildName(String imageBuildName) {
    this.imageBuildName = imageBuildName;
  }

  /**
   * 镜像来源，构建/普通镜像 */
  public String getImageSource() {
    return this.imageSource;
  }

  /**
   * 镜像来源，构建/普通镜像 */
  public void setImageSource(String imageSource) {
    this.imageSource = imageSource;
  }

  /**
   * 只读，标识是否是实时监控 sidecar 容器。在 request 请求中无需关心该值。在 response 中用来区分业务容器与系统容器。 */
  public Boolean getIsBizMonitorSidecar() {
    return this.isBizMonitorSidecar;
  }

  /**
   * 只读，标识是否是实时监控 sidecar 容器。在 request 请求中无需关心该值。在 response 中用来区分业务容器与系统容器。 */
  public void setIsBizMonitorSidecar(Boolean isBizMonitorSidecar) {
    this.isBizMonitorSidecar = isBizMonitorSidecar;
  }

  /**
   * 只读字段，用来表示该容器是否是mesh的sidecar容器 */
  public Boolean getIsMeshSidecar() {
    return this.isMeshSidecar;
  }

  /**
   * 只读字段，用来表示该容器是否是mesh的sidecar容器 */
  public void setIsMeshSidecar(Boolean isMeshSidecar) {
    this.isMeshSidecar = isMeshSidecar;
  }

  /**
   * 生命周期钩子 */
  public LifecycleHook getLifecycleHook() {
    return this.lifecycleHook;
  }

  /**
   * 生命周期钩子 */
  public void setLifecycleHook(LifecycleHook lifecycleHook) {
    this.lifecycleHook = lifecycleHook;
  }

  /**
   * 日志配置 */
  public List<LogConfig> getLogConfigs() {
    return this.logConfigs;
  }

  /**
   * 日志配置 */
  public void setLogConfigs(List<LogConfig> logConfigs) {
    this.logConfigs = logConfigs;
  }

  /**
   * 最大内存限制，单位 Byte/Ki/Mi/Gi/Ti/Pi */
  public String getMemoryLimit() {
    return this.memoryLimit;
  }

  /**
   * 最大内存限制，单位 Byte/Ki/Mi/Gi/Ti/Pi */
  public void setMemoryLimit(String memoryLimit) {
    this.memoryLimit = memoryLimit;
  }

  /**
   * 最小需要的内存大小，单位 Byte/Ki/Mi/Gi/Ti/Pi */
  public String getMemoryRequest() {
    return this.memoryRequest;
  }

  /**
   * 最小需要的内存大小，单位 Byte/Ki/Mi/Gi/Ti/Pi */
  public void setMemoryRequest(String memoryRequest) {
    this.memoryRequest = memoryRequest;
  }

  /**
   * 容器名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 容器名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 镜像拉取所需的保密字典 */
  public String getPullSecret() {
    return this.pullSecret;
  }

  /**
   * 镜像拉取所需的保密字典 */
  public void setPullSecret(String pullSecret) {
    this.pullSecret = pullSecret;
  }

  /**
   * 重启策略 */
  public String getRestartPolicy() {
    return this.restartPolicy;
  }

  /**
   * 重启策略 */
  public void setRestartPolicy(String restartPolicy) {
    this.restartPolicy = restartPolicy;
  }

  /**
   * 容器类型 */
  public String getType() {
    return this.type;
  }

  /**
   * 容器类型 */
  public void setType(String type) {
    this.type = type;
  }

  /**
   * 存储卷 */
  public List<Volume> getVolumeMounts() {
    return this.volumeMounts;
  }

  /**
   * 存储卷 */
  public void setVolumeMounts(List<Volume> volumeMounts) {
    this.volumeMounts = volumeMounts;
  }
}
