//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 容器服务版本 */
public class ContainerServiceRevision {
  @NotNull
  private ContainerServiceConfig config;

  @NotNull
  private String containerServiceName;

  @NotNull
  private Date createdTime;

  private String deployStatus;

  private String lastTimeSeriesId;

  private String metaStatus;

  @NotNull
  private Date modifiedTime;

  @NotNull
  private String operator;

  private String remarks;

  @NotNull
  private String revision;

  /**
   * 容器服务配置 */
  public ContainerServiceConfig getConfig() {
    return this.config;
  }

  /**
   * 容器服务配置 */
  public void setConfig(ContainerServiceConfig config) {
    this.config = config;
  }

  /**
   * 所属容器服务名称 */
  public String getContainerServiceName() {
    return this.containerServiceName;
  }

  /**
   * 所属容器服务名称 */
  public void setContainerServiceName(String containerServiceName) {
    this.containerServiceName = containerServiceName;
  }

  /**
   * 创建时间 */
  public Date getCreatedTime() {
    return this.createdTime;
  }

  /**
   * 创建时间 */
  public void setCreatedTime(Date createdTime) {
    this.createdTime = createdTime;
  }

  /**
   * 发布状态 */
  public String getDeployStatus() {
    return this.deployStatus;
  }

  /**
   * 发布状态 */
  public void setDeployStatus(String deployStatus) {
    this.deployStatus = deployStatus;
  }

  /**
   * 关联的最近一次发布单 */
  public String getLastTimeSeriesId() {
    return this.lastTimeSeriesId;
  }

  /**
   * 关联的最近一次发布单 */
  public void setLastTimeSeriesId(String lastTimeSeriesId) {
    this.lastTimeSeriesId = lastTimeSeriesId;
  }

  /**
   * 版本状态 */
  public String getMetaStatus() {
    return this.metaStatus;
  }

  /**
   * 版本状态 */
  public void setMetaStatus(String metaStatus) {
    this.metaStatus = metaStatus;
  }

  /**
   * 更新时间 */
  public Date getModifiedTime() {
    return this.modifiedTime;
  }

  /**
   * 更新时间 */
  public void setModifiedTime(Date modifiedTime) {
    this.modifiedTime = modifiedTime;
  }

  /**
   * 版本提交人 */
  public String getOperator() {
    return this.operator;
  }

  /**
   * 版本提交人 */
  public void setOperator(String operator) {
    this.operator = operator;
  }

  /**
   * 版本的备注 */
  public String getRemarks() {
    return this.remarks;
  }

  /**
   * 版本的备注 */
  public void setRemarks(String remarks) {
    this.remarks = remarks;
  }

  /**
   * 版本号 */
  public String getRevision() {
    return this.revision;
  }

  /**
   * 版本号 */
  public void setRevision(String revision) {
    this.revision = revision;
  }
}
