//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 容器服务的基础元信息 */
public class ContainerServiceMeta {
  @NotNull
  private String appName;

  @NotNull
  private String cluster;

  @NotNull
  private Date createdTime;

  private String deployingRevision;

  @NotNull
  private String deployStatus;

  private String draftedRevision;

  private Date draftedTime;

  private String lastDeployedRevision;

  @NotNull
  private Date lastDeployEndTime;

  private Date lastDeployStartTime;

  private String lastTimeSeriesId;

  private String metaStatus;

  @NotNull
  private Date modifiedTime;

  @NotNull
  private String name;

  @NotNull
  private String namespace;

  @NotNull
  private String owner;

  private String runtimeRevision;

  @NotNull
  private String workspace;

  /**
   * 应用名 */
  public String getAppName() {
    return this.appName;
  }

  /**
   * 应用名 */
  public void setAppName(String appName) {
    this.appName = appName;
  }

  /**
   * 所属集群名 */
  public String getCluster() {
    return this.cluster;
  }

  /**
   * 所属集群名 */
  public void setCluster(String cluster) {
    this.cluster = cluster;
  }

  /**
   * 创建时间 */
  public Date getCreatedTime() {
    return this.createdTime;
  }

  /**
   * 创建时间 */
  public void setCreatedTime(Date createdTime) {
    this.createdTime = createdTime;
  }

  /**
   * 发布中的版本 */
  public String getDeployingRevision() {
    return this.deployingRevision;
  }

  /**
   * 发布中的版本 */
  public void setDeployingRevision(String deployingRevision) {
    this.deployingRevision = deployingRevision;
  }

  /**
   * 发布部署状态 */
  public String getDeployStatus() {
    return this.deployStatus;
  }

  /**
   * 发布部署状态 */
  public void setDeployStatus(String deployStatus) {
    this.deployStatus = deployStatus;
  }

  /**
   * 当前应用服务草稿对应的版本号 */
  public String getDraftedRevision() {
    return this.draftedRevision;
  }

  /**
   * 当前应用服务草稿对应的版本号 */
  public void setDraftedRevision(String draftedRevision) {
    this.draftedRevision = draftedRevision;
  }

  /**
   * 草稿更新时间 */
  public Date getDraftedTime() {
    return this.draftedTime;
  }

  /**
   * 草稿更新时间 */
  public void setDraftedTime(Date draftedTime) {
    this.draftedTime = draftedTime;
  }

  /**
   * 最近一次发布的版本 */
  public String getLastDeployedRevision() {
    return this.lastDeployedRevision;
  }

  /**
   * 最近一次发布的版本 */
  public void setLastDeployedRevision(String lastDeployedRevision) {
    this.lastDeployedRevision = lastDeployedRevision;
  }

  /**
   * 最近一次发布的结束时间 */
  public Date getLastDeployEndTime() {
    return this.lastDeployEndTime;
  }

  /**
   * 最近一次发布的结束时间 */
  public void setLastDeployEndTime(Date lastDeployEndTime) {
    this.lastDeployEndTime = lastDeployEndTime;
  }

  /**
   * 最近一次发布的开始时间 */
  public Date getLastDeployStartTime() {
    return this.lastDeployStartTime;
  }

  /**
   * 最近一次发布的开始时间 */
  public void setLastDeployStartTime(Date lastDeployStartTime) {
    this.lastDeployStartTime = lastDeployStartTime;
  }

  /**
   * 最近一次关联的发布单 */
  public String getLastTimeSeriesId() {
    return this.lastTimeSeriesId;
  }

  /**
   * 最近一次关联的发布单 */
  public void setLastTimeSeriesId(String lastTimeSeriesId) {
    this.lastTimeSeriesId = lastTimeSeriesId;
  }

  /**
   * 应用服务状态 */
  public String getMetaStatus() {
    return this.metaStatus;
  }

  /**
   * 应用服务状态 */
  public void setMetaStatus(String metaStatus) {
    this.metaStatus = metaStatus;
  }

  /**
   * 更新时间 */
  public Date getModifiedTime() {
    return this.modifiedTime;
  }

  /**
   * 更新时间 */
  public void setModifiedTime(Date modifiedTime) {
    this.modifiedTime = modifiedTime;
  }

  /**
   * 名称 */
  public String getName() {
    return this.name;
  }

  /**
   * 名称 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 命名空间 */
  public String getNamespace() {
    return this.namespace;
  }

  /**
   * 命名空间 */
  public void setNamespace(String namespace) {
    this.namespace = namespace;
  }

  /**
   * 创建人 */
  public String getOwner() {
    return this.owner;
  }

  /**
   * 创建人 */
  public void setOwner(String owner) {
    this.owner = owner;
  }

  /**
   * 运行时版本 */
  public String getRuntimeRevision() {
    return this.runtimeRevision;
  }

  /**
   * 运行时版本 */
  public void setRuntimeRevision(String runtimeRevision) {
    this.runtimeRevision = runtimeRevision;
  }

  /**
   * 工作空间名 */
  public String getWorkspace() {
    return this.workspace;
  }

  /**
   * 工作空间名 */
  public void setWorkspace(String workspace) {
    this.workspace = workspace;
  }
}
