//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 容器服务部署模型 */
public class ContainerServiceDeployment {
  @NotNull
  private String containerServiceName;

  @NotNull
  private String containerServiceRevision;

  private List<String> dependContainerServiceName;

  /**
   * 容器服务实例名称 */
  public String getContainerServiceName() {
    return this.containerServiceName;
  }

  /**
   * 容器服务实例名称 */
  public void setContainerServiceName(String containerServiceName) {
    this.containerServiceName = containerServiceName;
  }

  /**
   * 容器服务版本号 */
  public String getContainerServiceRevision() {
    return this.containerServiceRevision;
  }

  /**
   * 容器服务版本号 */
  public void setContainerServiceRevision(String containerServiceRevision) {
    this.containerServiceRevision = containerServiceRevision;
  }

  /**
   * 依赖的其他容器服务名称 */
  public List<String> getDependContainerServiceName() {
    return this.dependContainerServiceName;
  }

  /**
   * 依赖的其他容器服务名称 */
  public void setDependContainerServiceName(List<String> dependContainerServiceName) {
    this.dependContainerServiceName = dependContainerServiceName;
  }
}
