//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 容器服务配置 */
public class ContainerServiceConfig {
  private List<String> bizMonitorPaths;

  private List<ClusterIpService> clusterIpServices;

  @NotNull
  private List<ContainerSpec> containerSpecs;

  @NotNull
  private DeployConfig deployConfig;

  private String description;

  private String dnsPolicy;

  @NotNull
  private ElasticConfig elasticConfig;

  private Boolean enableBizMonitor;

  private Boolean enableLogConfig;

  private Boolean enableMesh;

  private String hostNameTemplate;

  private List<InnerLoadBalancerService> innerLoadBalancerServices;

  private List<Tuple> meshProtocolMapping;

  @NotNull
  private String owner;

  private List<PublicLoadBalancerService> publicLoadBalancerServices;

  private TrafficRule trafficRule;

  private Boolean useHostNetwork;

  /**
   * 业务实时监控路径 */
  public List<String> getBizMonitorPaths() {
    return this.bizMonitorPaths;
  }

  /**
   * 业务实时监控路径 */
  public void setBizMonitorPaths(List<String> bizMonitorPaths) {
    this.bizMonitorPaths = bizMonitorPaths;
  }

  /**
   * 内网访问配置 */
  public List<ClusterIpService> getClusterIpServices() {
    return this.clusterIpServices;
  }

  /**
   * 内网访问配置 */
  public void setClusterIpServices(List<ClusterIpService> clusterIpServices) {
    this.clusterIpServices = clusterIpServices;
  }

  /**
   * 容器配置 */
  public List<ContainerSpec> getContainerSpecs() {
    return this.containerSpecs;
  }

  /**
   * 容器配置 */
  public void setContainerSpecs(List<ContainerSpec> containerSpecs) {
    this.containerSpecs = containerSpecs;
  }

  /**
   * 部署配置 */
  public DeployConfig getDeployConfig() {
    return this.deployConfig;
  }

  /**
   * 部署配置 */
  public void setDeployConfig(DeployConfig deployConfig) {
    this.deployConfig = deployConfig;
  }

  /**
   * 描述 */
  public String getDescription() {
    return this.description;
  }

  /**
   * 描述 */
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * DNS 策略 */
  public String getDnsPolicy() {
    return this.dnsPolicy;
  }

  /**
   * DNS 策略 */
  public void setDnsPolicy(String dnsPolicy) {
    this.dnsPolicy = dnsPolicy;
  }

  /**
   * 提供固定副本数，自动弹性扩缩容等配置 */
  public ElasticConfig getElasticConfig() {
    return this.elasticConfig;
  }

  /**
   * 提供固定副本数，自动弹性扩缩容等配置 */
  public void setElasticConfig(ElasticConfig elasticConfig) {
    this.elasticConfig = elasticConfig;
  }

  /**
   * 是否开启实时监控，默认 false */
  public Boolean getEnableBizMonitor() {
    return this.enableBizMonitor;
  }

  /**
   * 是否开启实时监控，默认 false */
  public void setEnableBizMonitor(Boolean enableBizMonitor) {
    this.enableBizMonitor = enableBizMonitor;
  }

  /**
   * 是否开启日志服务，默认 false */
  public Boolean getEnableLogConfig() {
    return this.enableLogConfig;
  }

  /**
   * 是否开启日志服务，默认 false */
  public void setEnableLogConfig(Boolean enableLogConfig) {
    this.enableLogConfig = enableLogConfig;
  }

  /**
   * 是否开启 MESH，默认 false */
  public Boolean getEnableMesh() {
    return this.enableMesh;
  }

  /**
   * 是否开启 MESH，默认 false */
  public void setEnableMesh(Boolean enableMesh) {
    this.enableMesh = enableMesh;
  }

  /**
   * pod 的主机名，不指定则用系统默认值 */
  public String getHostNameTemplate() {
    return this.hostNameTemplate;
  }

  /**
   * pod 的主机名，不指定则用系统默认值 */
  public void setHostNameTemplate(String hostNameTemplate) {
    this.hostNameTemplate = hostNameTemplate;
  }

  /**
   * 内网负载均衡访问配置 */
  public List<InnerLoadBalancerService> getInnerLoadBalancerServices() {
    return this.innerLoadBalancerServices;
  }

  /**
   * 内网负载均衡访问配置 */
  public void setInnerLoadBalancerServices(List<InnerLoadBalancerService> innerLoadBalancerServices) {
    this.innerLoadBalancerServices = innerLoadBalancerServices;
  }

  /**
   * mesh 协议映射 */
  public List<Tuple> getMeshProtocolMapping() {
    return this.meshProtocolMapping;
  }

  /**
   * mesh 协议映射 */
  public void setMeshProtocolMapping(List<Tuple> meshProtocolMapping) {
    this.meshProtocolMapping = meshProtocolMapping;
  }

  /**
   * 负责人 */
  public String getOwner() {
    return this.owner;
  }

  /**
   * 负责人 */
  public void setOwner(String owner) {
    this.owner = owner;
  }

  /**
   * 公网访问负载均衡配置 */
  public List<PublicLoadBalancerService> getPublicLoadBalancerServices() {
    return this.publicLoadBalancerServices;
  }

  /**
   * 公网访问负载均衡配置 */
  public void setPublicLoadBalancerServices(List<PublicLoadBalancerService> publicLoadBalancerServices) {
    this.publicLoadBalancerServices = publicLoadBalancerServices;
  }

  /**
   * MESH 流量规则 */
  public TrafficRule getTrafficRule() {
    return this.trafficRule;
  }

  /**
   * MESH 流量规则 */
  public void setTrafficRule(TrafficRule trafficRule) {
    this.trafficRule = trafficRule;
  }

  /**
   * 是否使用宿主机网络 */
  public Boolean getUseHostNetwork() {
    return this.useHostNetwork;
  }

  /**
   * 是否使用宿主机网络 */
  public void setUseHostNetwork(Boolean useHostNetwork) {
    this.useHostNetwork = useHostNetwork;
  }
}
