//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 容器服务实例，在AppService上基于容器化部署增加的一层抽象 */
public class ContainerService {
  @NotNull
  private List<String> cellIds;

  @NotNull
  private List<ContainerInfo> containers;

  @NotNull
  private String containerServiceName;

  @NotNull
  private String deployState;

  @NotNull
  private String metaState;

  @NotNull
  private Long replicas;

  /**
   * 关联的部署单元paas id
   */
  public List<String> getCellIds() {
    return this.cellIds;
  }

  /**
   * 关联的部署单元paas id
   */
  public void setCellIds(List<String> cellIds) {
    this.cellIds = cellIds;
  }

  /**
   * 容器配置
   */
  public List<ContainerInfo> getContainers() {
    return this.containers;
  }

  /**
   * 容器配置
   */
  public void setContainers(List<ContainerInfo> containers) {
    this.containers = containers;
  }

  /**
   * 容器服务实例名称 */
  public String getContainerServiceName() {
    return this.containerServiceName;
  }

  /**
   * 容器服务实例名称 */
  public void setContainerServiceName(String containerServiceName) {
    this.containerServiceName = containerServiceName;
  }

  /**
   * containerService部署状态，取值
   * EXECUTING
   * INITIALIZE_FAILED
   * SUCCEEDED
   * WAITING_FOR_DEPLOY */
  public String getDeployState() {
    return this.deployState;
  }

  /**
   * containerService部署状态，取值
   * EXECUTING
   * INITIALIZE_FAILED
   * SUCCEEDED
   * WAITING_FOR_DEPLOY */
  public void setDeployState(String deployState) {
    this.deployState = deployState;
  }

  /**
   * containerService创建状态，取值
   * CREATED
   * FAILED
   * EXECUTING */
  public String getMetaState() {
    return this.metaState;
  }

  /**
   * containerService创建状态，取值
   * CREATED
   * FAILED
   * EXECUTING */
  public void setMetaState(String metaState) {
    this.metaState = metaState;
  }

  /**
   * 副本数量 */
  public Long getReplicas() {
    return this.replicas;
  }

  /**
   * 副本数量 */
  public void setReplicas(Long replicas) {
    this.replicas = replicas;
  }
}
