//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Boolean;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 容器配置 */
public class ContainerConfig {
  private String command;

  @NotNull
  private String containerName;

  @NotNull
  private String cpuLimit;

  @NotNull
  private String cpuRequest;

  private List<Env> envs;

  private HealthCheckConfigInfo healthCheckConfigInfo;

  @NotNull
  private String image;

  private Boolean isSidecar;

  @NotNull
  private String memoryLimit;

  @NotNull
  private String memoryRequest;

  private List<Volume> volumes;

  /**
   * 启动命令 */
  public String getCommand() {
    return this.command;
  }

  /**
   * 启动命令 */
  public void setCommand(String command) {
    this.command = command;
  }

  /**
   * 容器名 */
  public String getContainerName() {
    return this.containerName;
  }

  /**
   * 容器名 */
  public void setContainerName(String containerName) {
    this.containerName = containerName;
  }

  /**
   * cpu limit，取值
   * 1c/500m */
  public String getCpuLimit() {
    return this.cpuLimit;
  }

  /**
   * cpu limit，取值
   * 1c/500m */
  public void setCpuLimit(String cpuLimit) {
    this.cpuLimit = cpuLimit;
  }

  /**
   * cpu request，取值
   * 1c/500m */
  public String getCpuRequest() {
    return this.cpuRequest;
  }

  /**
   * cpu request，取值
   * 1c/500m */
  public void setCpuRequest(String cpuRequest) {
    this.cpuRequest = cpuRequest;
  }

  /**
   * 环境参数 */
  public List<Env> getEnvs() {
    return this.envs;
  }

  /**
   * 环境参数 */
  public void setEnvs(List<Env> envs) {
    this.envs = envs;
  }

  /**
   * 健康检查 */
  public HealthCheckConfigInfo getHealthCheckConfigInfo() {
    return this.healthCheckConfigInfo;
  }

  /**
   * 健康检查 */
  public void setHealthCheckConfigInfo(HealthCheckConfigInfo healthCheckConfigInfo) {
    this.healthCheckConfigInfo = healthCheckConfigInfo;
  }

  /**
   * 镜像地址 */
  public String getImage() {
    return this.image;
  }

  /**
   * 镜像地址 */
  public void setImage(String image) {
    this.image = image;
  }

  /**
   * 是否sidecar容器 */
  public Boolean getIsSidecar() {
    return this.isSidecar;
  }

  /**
   * 是否sidecar容器 */
  public void setIsSidecar(Boolean isSidecar) {
    this.isSidecar = isSidecar;
  }

  /**
   * memory limit，取值
   * 4G/4M/4T/4P */
  public String getMemoryLimit() {
    return this.memoryLimit;
  }

  /**
   * memory limit，取值
   * 4G/4M/4T/4P */
  public void setMemoryLimit(String memoryLimit) {
    this.memoryLimit = memoryLimit;
  }

  /**
   * memory request，取值
   * 4G/4M/4T/4P */
  public String getMemoryRequest() {
    return this.memoryRequest;
  }

  /**
   * memory request，取值
   * 4G/4M/4T/4P */
  public void setMemoryRequest(String memoryRequest) {
    this.memoryRequest = memoryRequest;
  }

  /**
   * 数据卷配置 */
  public List<Volume> getVolumes() {
    return this.volumes;
  }

  /**
   * 数据卷配置 */
  public void setVolumes(List<Volume> volumes) {
    this.volumes = volumes;
  }
}
