//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * ECS Computer基础信息 */
public class ComputerInfo {
  @NotNull
  private String cellId;

  @NotNull
  private String hostname;

  @NotNull
  private String iaasId;

  @NotNull
  private String iaasStatus;

  @NotNull
  private String paasId;

  @NotNull
  private String privateIp;

  @NotNull
  private String regionId;

  @NotNull
  private String specIaasId;

  @NotNull
  private String uniqueId;

  @NotNull
  private String workspaceId;

  @NotNull
  private String zoneId;

  /**
   * 部署单元id */
  public String getCellId() {
    return this.cellId;
  }

  /**
   * 部署单元id */
  public void setCellId(String cellId) {
    this.cellId = cellId;
  }

  /**
   * 集群主机名称 */
  public String getHostname() {
    return this.hostname;
  }

  /**
   * 集群主机名称 */
  public void setHostname(String hostname) {
    this.hostname = hostname;
  }

  /**
   * ECS iaasId，对应阿里云ECS id */
  public String getIaasId() {
    return this.iaasId;
  }

  /**
   * ECS iaasId，对应阿里云ECS id */
  public void setIaasId(String iaasId) {
    this.iaasId = iaasId;
  }

  /**
   * ECS运行状态 */
  public String getIaasStatus() {
    return this.iaasStatus;
  }

  /**
   * ECS运行状态 */
  public void setIaasStatus(String iaasStatus) {
    this.iaasStatus = iaasStatus;
  }

  /**
   * ECS paasId */
  public String getPaasId() {
    return this.paasId;
  }

  /**
   * ECS paasId */
  public void setPaasId(String paasId) {
    this.paasId = paasId;
  }

  /**
   * ECS私有IP */
  public String getPrivateIp() {
    return this.privateIp;
  }

  /**
   * ECS私有IP */
  public void setPrivateIp(String privateIp) {
    this.privateIp = privateIp;
  }

  /**
   * Region id */
  public String getRegionId() {
    return this.regionId;
  }

  /**
   * Region id */
  public void setRegionId(String regionId) {
    this.regionId = regionId;
  }

  /**
   * ECS规格iaasId */
  public String getSpecIaasId() {
    return this.specIaasId;
  }

  /**
   * ECS规格iaasId */
  public void setSpecIaasId(String specIaasId) {
    this.specIaasId = specIaasId;
  }

  /**
   * ECS paasId */
  public String getUniqueId() {
    return this.uniqueId;
  }

  /**
   * ECS paasId */
  public void setUniqueId(String uniqueId) {
    this.uniqueId = uniqueId;
  }

  /**
   * Workspace id */
  public String getWorkspaceId() {
    return this.workspaceId;
  }

  /**
   * Workspace id */
  public void setWorkspaceId(String workspaceId) {
    this.workspaceId = workspaceId;
  }

  /**
   * 可用区id */
  public String getZoneId() {
    return this.zoneId;
  }

  /**
   * 可用区id */
  public void setZoneId(String zoneId) {
    this.zoneId = zoneId;
  }
}
