//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import java.util.Date;
import javax.validation.constraints.NotNull;

/**
 * 构建信息 */
public class BuildStream {
  @NotNull
  private String appName;

  @NotNull
  private String buildMessage;

  @NotNull
  private Long buildNumber;

  private Long duration;

  private Date endTime;

  private String imageId;

  private String imageSha;

  private String imageTag;

  private String imageUrl;

  private String logUrl;

  private String operator;

  private String operatorDisplayName;

  @NotNull
  private String scmBranch;

  private String scmLog;

  @NotNull
  private String scmRevision;

  @NotNull
  private String scmUrl;

  private String scmUser;

  private Date startTime;

  private String status;

  /**
   * app ID */
  public String getAppName() {
    return this.appName;
  }

  /**
   * app ID */
  public void setAppName(String appName) {
    this.appName = appName;
  }

  /**
   * build message */
  public String getBuildMessage() {
    return this.buildMessage;
  }

  /**
   * build message */
  public void setBuildMessage(String buildMessage) {
    this.buildMessage = buildMessage;
  }

  /**
   * build 序号 */
  public Long getBuildNumber() {
    return this.buildNumber;
  }

  /**
   * build 序号 */
  public void setBuildNumber(Long buildNumber) {
    this.buildNumber = buildNumber;
  }

  /**
   * total build time */
  public Long getDuration() {
    return this.duration;
  }

  /**
   * total build time */
  public void setDuration(Long duration) {
    this.duration = duration;
  }

  /**
   * end time */
  public Date getEndTime() {
    return this.endTime;
  }

  /**
   * end time */
  public void setEndTime(Date endTime) {
    this.endTime = endTime;
  }

  /**
   * image id */
  public String getImageId() {
    return this.imageId;
  }

  /**
   * image id */
  public void setImageId(String imageId) {
    this.imageId = imageId;
  }

  /**
   * sha sum */
  public String getImageSha() {
    return this.imageSha;
  }

  /**
   * sha sum */
  public void setImageSha(String imageSha) {
    this.imageSha = imageSha;
  }

  /**
   * image tag */
  public String getImageTag() {
    return this.imageTag;
  }

  /**
   * image tag */
  public void setImageTag(String imageTag) {
    this.imageTag = imageTag;
  }

  /**
   * image url */
  public String getImageUrl() {
    return this.imageUrl;
  }

  /**
   * image url */
  public void setImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
  }

  /**
   * 日志地址 */
  public String getLogUrl() {
    return this.logUrl;
  }

  /**
   * 日志地址 */
  public void setLogUrl(String logUrl) {
    this.logUrl = logUrl;
  }

  /**
   * 触发构建的用户 */
  public String getOperator() {
    return this.operator;
  }

  /**
   * 触发构建的用户 */
  public void setOperator(String operator) {
    this.operator = operator;
  }

  /**
   * 触发构建的人的名称 */
  public String getOperatorDisplayName() {
    return this.operatorDisplayName;
  }

  /**
   * 触发构建的人的名称 */
  public void setOperatorDisplayName(String operatorDisplayName) {
    this.operatorDisplayName = operatorDisplayName;
  }

  /**
   * 代码分支 */
  public String getScmBranch() {
    return this.scmBranch;
  }

  /**
   * 代码分支 */
  public void setScmBranch(String scmBranch) {
    this.scmBranch = scmBranch;
  }

  /**
   * commit message */
  public String getScmLog() {
    return this.scmLog;
  }

  /**
   * commit message */
  public void setScmLog(String scmLog) {
    this.scmLog = scmLog;
  }

  /**
   * commit id */
  public String getScmRevision() {
    return this.scmRevision;
  }

  /**
   * commit id */
  public void setScmRevision(String scmRevision) {
    this.scmRevision = scmRevision;
  }

  /**
   * 代码地址 */
  public String getScmUrl() {
    return this.scmUrl;
  }

  /**
   * 代码地址 */
  public void setScmUrl(String scmUrl) {
    this.scmUrl = scmUrl;
  }

  /**
   * 代码提交者 */
  public String getScmUser() {
    return this.scmUser;
  }

  /**
   * 代码提交者 */
  public void setScmUser(String scmUser) {
    this.scmUser = scmUser;
  }

  /**
   * start time */
  public Date getStartTime() {
    return this.startTime;
  }

  /**
   * start time */
  public void setStartTime(Date startTime) {
    this.startTime = startTime;
  }

  /**
   * 构建状态 */
  public String getStatus() {
    return this.status;
  }

  /**
   * 构建状态 */
  public void setStatus(String status) {
    this.status = status;
  }
}
