//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.provider.aks.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * BuildConfigApp */
public class BuildConfigApp {
  @NotNull
  private String appBuildName;

  @NotNull
  private String appName;

  @NotNull
  private String appOwnerDisplayName;

  @NotNull
  private String compileDir;

  @NotNull
  private String compileDockerfile;

  @NotNull
  private List<String> dockerCredential;

  @NotNull
  private String externalDockerCredential;

  @NotNull
  private String externalImageName;

  @NotNull
  private String gitlabAccessId;

  @NotNull
  private String gitlabAccessToken;

  @NotNull
  private String id;

  @NotNull
  private String imageUrl;

  @NotNull
  private Long latestBuildNumber;

  @NotNull
  private String ownerId;

  @NotNull
  private String scmUrl;

  @NotNull
  private String status;

  @NotNull
  private String tenantId;

  @NotNull
  private Date utcCreateTime;

  @NotNull
  private Date utcUpdateTime;

  /**
   * app_build_name */
  public String getAppBuildName() {
    return this.appBuildName;
  }

  /**
   * app_build_name */
  public void setAppBuildName(String appBuildName) {
    this.appBuildName = appBuildName;
  }

  /**
   * app name */
  public String getAppName() {
    return this.appName;
  }

  /**
   * app name */
  public void setAppName(String appName) {
    this.appName = appName;
  }

  /**
   * app_owner_display_name */
  public String getAppOwnerDisplayName() {
    return this.appOwnerDisplayName;
  }

  /**
   * app_owner_display_name */
  public void setAppOwnerDisplayName(String appOwnerDisplayName) {
    this.appOwnerDisplayName = appOwnerDisplayName;
  }

  /**
   * compile_dir */
  public String getCompileDir() {
    return this.compileDir;
  }

  /**
   * compile_dir */
  public void setCompileDir(String compileDir) {
    this.compileDir = compileDir;
  }

  /**
   * compileDockerfile */
  public String getCompileDockerfile() {
    return this.compileDockerfile;
  }

  /**
   * compileDockerfile */
  public void setCompileDockerfile(String compileDockerfile) {
    this.compileDockerfile = compileDockerfile;
  }

  /**
   * docker_credential */
  public List<String> getDockerCredential() {
    return this.dockerCredential;
  }

  /**
   * docker_credential */
  public void setDockerCredential(List<String> dockerCredential) {
    this.dockerCredential = dockerCredential;
  }

  /**
   * external_docker_credential */
  public String getExternalDockerCredential() {
    return this.externalDockerCredential;
  }

  /**
   * external_docker_credential */
  public void setExternalDockerCredential(String externalDockerCredential) {
    this.externalDockerCredential = externalDockerCredential;
  }

  /**
   * external_image_name */
  public String getExternalImageName() {
    return this.externalImageName;
  }

  /**
   * external_image_name */
  public void setExternalImageName(String externalImageName) {
    this.externalImageName = externalImageName;
  }

  /**
   * gitlab_access_id */
  public String getGitlabAccessId() {
    return this.gitlabAccessId;
  }

  /**
   * gitlab_access_id */
  public void setGitlabAccessId(String gitlabAccessId) {
    this.gitlabAccessId = gitlabAccessId;
  }

  /**
   * gitlab_access_token */
  public String getGitlabAccessToken() {
    return this.gitlabAccessToken;
  }

  /**
   * gitlab_access_token */
  public void setGitlabAccessToken(String gitlabAccessToken) {
    this.gitlabAccessToken = gitlabAccessToken;
  }

  /**
   * id */
  public String getId() {
    return this.id;
  }

  /**
   * id */
  public void setId(String id) {
    this.id = id;
  }

  /**
   * image_url */
  public String getImageUrl() {
    return this.imageUrl;
  }

  /**
   * image_url */
  public void setImageUrl(String imageUrl) {
    this.imageUrl = imageUrl;
  }

  /**
   * latest_build_number */
  public Long getLatestBuildNumber() {
    return this.latestBuildNumber;
  }

  /**
   * latest_build_number */
  public void setLatestBuildNumber(Long latestBuildNumber) {
    this.latestBuildNumber = latestBuildNumber;
  }

  /**
   * owner_id */
  public String getOwnerId() {
    return this.ownerId;
  }

  /**
   * owner_id */
  public void setOwnerId(String ownerId) {
    this.ownerId = ownerId;
  }

  /**
   * scm_url */
  public String getScmUrl() {
    return this.scmUrl;
  }

  /**
   * scm_url */
  public void setScmUrl(String scmUrl) {
    this.scmUrl = scmUrl;
  }

  /**
   * status */
  public String getStatus() {
    return this.status;
  }

  /**
   * status */
  public void setStatus(String status) {
    this.status = status;
  }

  /**
   * tenant_id */
  public String getTenantId() {
    return this.tenantId;
  }

  /**
   * tenant_id */
  public void setTenantId(String tenantId) {
    this.tenantId = tenantId;
  }

  /**
   * utcCreateTime */
  public Date getUtcCreateTime() {
    return this.utcCreateTime;
  }

  /**
   * utcCreateTime */
  public void setUtcCreateTime(Date utcCreateTime) {
    this.utcCreateTime = utcCreateTime;
  }

  /**
   * utcUpdateTime */
  public Date getUtcUpdateTime() {
    return this.utcUpdateTime;
  }

  /**
   * utcUpdateTime */
  public void setUtcUpdateTime(Date utcUpdateTime) {
    this.utcUpdateTime = utcUpdateTime;
  }
}
