//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.ocp.v1_0_0.request;

import cn.com.antcloud.api.ocp.v1_0_0.response.SendObHcResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * health-check */
public class SendObHcRequest extends AntCloudProdRequest<SendObHcResponse> {
  @NotNull
  private String action;

  @NotNull
  private String clusterName;

  @NotNull
  private String regionId;

  public SendObHcRequest(String productInstanceId) {
    super("ob.ocp.ob.hc.send", "1.0", "Java-SDK-20190401", productInstanceId);
  }

  public SendObHcRequest() {
    super("ob.ocp.ob.hc.send", "1.0", null);
    this.setSdkVersion("Java-SDK-20190401");
  }

  /**
   * Obpaas */
  public String getAction() {
    return this.action;
  }

  /**
   * Obpaas */
  public void setAction(String action) {
    this.action = action;
  }

  /**
   * obocp2 */
  public String getClusterName() {
    return this.clusterName;
  }

  /**
   * obocp2 */
  public void setClusterName(String clusterName) {
    this.clusterName = clusterName;
  }

  /**
   * hangzhou */
  public String getRegionId() {
    return this.regionId;
  }

  /**
   * hangzhou */
  public void setRegionId(String regionId) {
    this.regionId = regionId;
  }
}
