//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.ocp.v1_0_0.request;

import cn.com.antcloud.api.ocp.v1_0_0.response.DescribeObpaasInstanceResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * DescribeDBInstances */
public class DescribeObpaasInstanceRequest extends AntCloudProdRequest<DescribeObpaasInstanceResponse> {
  @NotNull
  private String accessKeyId;

  @NotNull
  private String action;

  @NotNull
  private String obCluster;

  @NotNull
  private Long pageNumber;

  @NotNull
  private Long pageSize;

  private String regionId;

  public DescribeObpaasInstanceRequest(String productInstanceId) {
    super("ob.ocp.obpaas.instance.describe", "1.0", "Java-SDK-20190401", productInstanceId);
  }

  public DescribeObpaasInstanceRequest() {
    super("ob.ocp.obpaas.instance.describe", "1.0", null);
    this.setSdkVersion("Java-SDK-20190401");
  }

  /**
   * 用户名 */
  public String getAccessKeyId() {
    return this.accessKeyId;
  }

  /**
   * 用户名 */
  public void setAccessKeyId(String accessKeyId) {
    this.accessKeyId = accessKeyId;
  }

  /**
   * DescribeDBInstances */
  public String getAction() {
    return this.action;
  }

  /**
   * DescribeDBInstances */
  public void setAction(String action) {
    this.action = action;
  }

  /**
   * 创建实例所在的OB集群 */
  public String getObCluster() {
    return this.obCluster;
  }

  /**
   * 创建实例所在的OB集群 */
  public void setObCluster(String obCluster) {
    this.obCluster = obCluster;
  }

  /**
   * default = 1 */
  public Long getPageNumber() {
    return this.pageNumber;
  }

  /**
   * default = 1 */
  public void setPageNumber(Long pageNumber) {
    this.pageNumber = pageNumber;
  }

  /**
   * default = 20000 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * default = 20000 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 金融云地域 */
  public String getRegionId() {
    return this.regionId;
  }

  /**
   * 金融云地域 */
  public void setRegionId(String regionId) {
    this.regionId = regionId;
  }
}
