//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.ocp.v1_0_0.request;

import cn.com.antcloud.api.ocp.v1_0_0.response.DeleteObpaasInstanceResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 删除实例 */
public class DeleteObpaasInstanceRequest extends AntCloudProdRequest<DeleteObpaasInstanceResponse> {
  @NotNull
  private String action;

  @NotNull
  private String dbInstanceId;

  private String engine;

  @NotNull
  private String obCluster;

  public DeleteObpaasInstanceRequest(String productInstanceId) {
    super("ob.ocp.obpaas.instance.delete", "1.0", "Java-SDK-20190401", productInstanceId);
  }

  public DeleteObpaasInstanceRequest() {
    super("ob.ocp.obpaas.instance.delete", "1.0", null);
    this.setSdkVersion("Java-SDK-20190401");
  }

  /**
   * 操作标识符 */
  public String getAction() {
    return this.action;
  }

  /**
   * 操作标识符 */
  public void setAction(String action) {
    this.action = action;
  }

  /**
   * 实例名 */
  public String getDbInstanceId() {
    return this.dbInstanceId;
  }

  /**
   * 实例名 */
  public void setDbInstanceId(String dbInstanceId) {
    this.dbInstanceId = dbInstanceId;
  }

  /**
   * -- */
  public String getEngine() {
    return this.engine;
  }

  /**
   * -- */
  public void setEngine(String engine) {
    this.engine = engine;
  }

  /**
   * OB集群 */
  public String getObCluster() {
    return this.obCluster;
  }

  /**
   * OB集群 */
  public void setObCluster(String obCluster) {
    this.obCluster = obCluster;
  }
}
