//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.ocp.v1_0_0.request;

import cn.com.antcloud.api.ocp.v1_0_0.response.CreateObpaasInstanceResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 创建OB实例，对应OB内部术语为创建租户 */
public class CreateObpaasInstanceRequest extends AntCloudProdRequest<CreateObpaasInstanceResponse> {
  @NotNull
  private String action;

  @NotNull
  private String dbInstanceClass;

  private String dbInstanceDescription;

  private String dbInstanceNetType;

  private String dbInstanceStorage;

  private String engine;

  private String engineVersion;

  private String format;

  private String instanceNetworkType;

  @NotNull
  private String obCluster;

  private String payType;

  @NotNull
  private String regionId;

  private String securityIpList;

  private String timestamp;

  public CreateObpaasInstanceRequest(String productInstanceId) {
    super("ob.ocp.obpaas.instance.create", "1.0", "Java-SDK-20190401", productInstanceId);
  }

  public CreateObpaasInstanceRequest() {
    super("ob.ocp.obpaas.instance.create", "1.0", null);
    this.setSdkVersion("Java-SDK-20190401");
  }

  /**
   * Action标识符 */
  public String getAction() {
    return this.action;
  }

  /**
   * Action标识符 */
  public void setAction(String action) {
    this.action = action;
  }

  /**
   * 租户规格，需要按枚举提前配入元数据中心 */
  public String getDbInstanceClass() {
    return this.dbInstanceClass;
  }

  /**
   * 租户规格，需要按枚举提前配入元数据中心 */
  public void setDbInstanceClass(String dbInstanceClass) {
    this.dbInstanceClass = dbInstanceClass;
  }

  /**
   * 实例信息描述 */
  public String getDbInstanceDescription() {
    return this.dbInstanceDescription;
  }

  /**
   * 实例信息描述 */
  public void setDbInstanceDescription(String dbInstanceDescription) {
    this.dbInstanceDescription = dbInstanceDescription;
  }

  /**
   * -- */
  public String getDbInstanceNetType() {
    return this.dbInstanceNetType;
  }

  /**
   * -- */
  public void setDbInstanceNetType(String dbInstanceNetType) {
    this.dbInstanceNetType = dbInstanceNetType;
  }

  /**
   * -- */
  public String getDbInstanceStorage() {
    return this.dbInstanceStorage;
  }

  /**
   * -- */
  public void setDbInstanceStorage(String dbInstanceStorage) {
    this.dbInstanceStorage = dbInstanceStorage;
  }

  /**
   * -- */
  public String getEngine() {
    return this.engine;
  }

  /**
   * -- */
  public void setEngine(String engine) {
    this.engine = engine;
  }

  /**
   * -- */
  public String getEngineVersion() {
    return this.engineVersion;
  }

  /**
   * -- */
  public void setEngineVersion(String engineVersion) {
    this.engineVersion = engineVersion;
  }

  /**
   * -- */
  public String getFormat() {
    return this.format;
  }

  /**
   * -- */
  public void setFormat(String format) {
    this.format = format;
  }

  /**
   * -- */
  public String getInstanceNetworkType() {
    return this.instanceNetworkType;
  }

  /**
   * -- */
  public void setInstanceNetworkType(String instanceNetworkType) {
    this.instanceNetworkType = instanceNetworkType;
  }

  /**
   * OB集群 */
  public String getObCluster() {
    return this.obCluster;
  }

  /**
   * OB集群 */
  public void setObCluster(String obCluster) {
    this.obCluster = obCluster;
  }

  /**
   * 付费类型 */
  public String getPayType() {
    return this.payType;
  }

  /**
   * 付费类型 */
  public void setPayType(String payType) {
    this.payType = payType;
  }

  /**
   * 金融云region */
  public String getRegionId() {
    return this.regionId;
  }

  /**
   * 金融云region */
  public void setRegionId(String regionId) {
    this.regionId = regionId;
  }

  /**
   * IP白名单 */
  public String getSecurityIpList() {
    return this.securityIpList;
  }

  /**
   * IP白名单 */
  public void setSecurityIpList(String securityIpList) {
    this.securityIpList = securityIpList;
  }

  /**
   * 幂等性 */
  public String getTimestamp() {
    return this.timestamp;
  }

  /**
   * 幂等性 */
  public void setTimestamp(String timestamp) {
    this.timestamp = timestamp;
  }
}
