//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.ocp.v1_0_0.model;

import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 实例详情domain */
public class DBInstanceItem {
  @NotNull
  private String connectionString;

  @NotNull
  private String dbInstanceClass;

  @NotNull
  private String dbInstanceDescription;

  @NotNull
  private String dbInstanceId;

  @NotNull
  private Long dbInstanceMemory;

  @NotNull
  private String dbInstanceNetType;

  @NotNull
  private Long dbInstanceStorage;

  @NotNull
  private String dbInstanceType;

  @NotNull
  private String engine;

  @NotNull
  private String engineVersion;

  @NotNull
  private Long maxConnections;

  @NotNull
  private Long maxIops;

  @NotNull
  private String payType;

  @NotNull
  private Long port;

  @NotNull
  private String regionId;

  @NotNull
  private String securityIpList;

  /**
   * 连接串信息 */
  public String getConnectionString() {
    return this.connectionString;
  }

  /**
   * 连接串信息 */
  public void setConnectionString(String connectionString) {
    this.connectionString = connectionString;
  }

  /**
   * 实例规格 */
  public String getDbInstanceClass() {
    return this.dbInstanceClass;
  }

  /**
   * 实例规格 */
  public void setDbInstanceClass(String dbInstanceClass) {
    this.dbInstanceClass = dbInstanceClass;
  }

  /**
   * 实例描述 */
  public String getDbInstanceDescription() {
    return this.dbInstanceDescription;
  }

  /**
   * 实例描述 */
  public void setDbInstanceDescription(String dbInstanceDescription) {
    this.dbInstanceDescription = dbInstanceDescription;
  }

  /**
   * 实例名 */
  public String getDbInstanceId() {
    return this.dbInstanceId;
  }

  /**
   * 实例名 */
  public void setDbInstanceId(String dbInstanceId) {
    this.dbInstanceId = dbInstanceId;
  }

  /**
   * 实例内存规格 */
  public Long getDbInstanceMemory() {
    return this.dbInstanceMemory;
  }

  /**
   * 实例内存规格 */
  public void setDbInstanceMemory(Long dbInstanceMemory) {
    this.dbInstanceMemory = dbInstanceMemory;
  }

  /**
   * 实例网络规格 */
  public String getDbInstanceNetType() {
    return this.dbInstanceNetType;
  }

  /**
   * 实例网络规格 */
  public void setDbInstanceNetType(String dbInstanceNetType) {
    this.dbInstanceNetType = dbInstanceNetType;
  }

  /**
   * 实例磁盘规格 */
  public Long getDbInstanceStorage() {
    return this.dbInstanceStorage;
  }

  /**
   * 实例磁盘规格 */
  public void setDbInstanceStorage(Long dbInstanceStorage) {
    this.dbInstanceStorage = dbInstanceStorage;
  }

  /**
   * db_instance_type */
  public String getDbInstanceType() {
    return this.dbInstanceType;
  }

  /**
   * db_instance_type */
  public void setDbInstanceType(String dbInstanceType) {
    this.dbInstanceType = dbInstanceType;
  }

  /**
   * db引擎 */
  public String getEngine() {
    return this.engine;
  }

  /**
   * db引擎 */
  public void setEngine(String engine) {
    this.engine = engine;
  }

  /**
   * EngineVersion */
  public String getEngineVersion() {
    return this.engineVersion;
  }

  /**
   * EngineVersion */
  public void setEngineVersion(String engineVersion) {
    this.engineVersion = engineVersion;
  }

  /**
   * 最大连接数 */
  public Long getMaxConnections() {
    return this.maxConnections;
  }

  /**
   * 最大连接数 */
  public void setMaxConnections(Long maxConnections) {
    this.maxConnections = maxConnections;
  }

  /**
   * max_iops */
  public Long getMaxIops() {
    return this.maxIops;
  }

  /**
   * max_iops */
  public void setMaxIops(Long maxIops) {
    this.maxIops = maxIops;
  }

  /**
   * 付费规格 */
  public String getPayType() {
    return this.payType;
  }

  /**
   * 付费规格 */
  public void setPayType(String payType) {
    this.payType = payType;
  }

  /**
   * port */
  public Long getPort() {
    return this.port;
  }

  /**
   * port */
  public void setPort(Long port) {
    this.port = port;
  }

  /**
   * 金融云地域 */
  public String getRegionId() {
    return this.regionId;
  }

  /**
   * 金融云地域 */
  public void setRegionId(String regionId) {
    this.regionId = regionId;
  }

  /**
   * 实例访问IP白名单 */
  public String getSecurityIpList() {
    return this.securityIpList;
  }

  /**
   * 实例访问IP白名单 */
  public void setSecurityIpList(String securityIpList) {
    this.securityIpList = securityIpList;
  }
}
