//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.response;

import cn.com.antcloud.api.blockchain.v1_0_0.model.OrderResult;
import cn.com.antcloud.api.product.AntCloudProdResponse;
import java.lang.String;
import java.util.List;

/**
 * 对于操作型指令（创建、变配）平台用来查询底层对指定订单的生产结果（如果超过规定时间没有主动告知平台结果） */
public class QueryProductResponse extends AntCloudProdResponse {
  private List<OrderResult> orderResults;

  private String reqMsgId;

  private String resultCode;

  private String resultMsg;

  /**
   * 订单查询结果 */
  public List<OrderResult> getOrderResults() {
    return this.orderResults;
  }

  /**
   * 订单查询结果 */
  public void setOrderResults(List<OrderResult> orderResults) {
    this.orderResults = orderResults;
  }

  /**
   * 请求中的req_msg_id */
  public String getReqMsgId() {
    return this.reqMsgId;
  }

  /**
   * 请求中的req_msg_id */
  public void setReqMsgId(String reqMsgId) {
    this.reqMsgId = reqMsgId;
  }

  /**
   * 结果码 */
  public String getResultCode() {
    return this.resultCode;
  }

  /**
   * 结果码 */
  public void setResultCode(String resultCode) {
    this.resultCode = resultCode;
  }

  /**
   * 结果消息 */
  public String getResultMsg() {
    return this.resultMsg;
  }

  /**
   * 结果消息 */
  public void setResultMsg(String resultMsg) {
    this.resultMsg = resultMsg;
  }
}
