//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.response;

import cn.com.antcloud.api.blockchain.v1_0_0.model.EPTradeInfo;
import cn.com.antcloud.api.product.AntCloudProdResponse;
import java.lang.Long;
import java.util.List;

/**
 * 数字资产管理平台交易查询接口
 * 1. ep_code有值，user_account为空时，查询版通的交易信息
 * 2. ep_code为空，user_account有值时，查询账户的交易信息
 * 3. ep_code，user_account均有值时，查询账户下指定版通的交易信息 */
public class QueryExchangeEptradeResponse extends AntCloudProdResponse {
  private Long pageNum;

  private Long pageSize;

  private Long totalCount;

  private List<EPTradeInfo> txInfos;

  /**
   * 页数 从1开始 */
  public Long getPageNum() {
    return this.pageNum;
  }

  /**
   * 页数 从1开始 */
  public void setPageNum(Long pageNum) {
    this.pageNum = pageNum;
  }

  /**
   * 每页显示数量 */
  public Long getPageSize() {
    return this.pageSize;
  }

  /**
   * 每页显示数量 */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * 数据总量 */
  public Long getTotalCount() {
    return this.totalCount;
  }

  /**
   * 数据总量 */
  public void setTotalCount(Long totalCount) {
    this.totalCount = totalCount;
  }

  /**
   * 交易信息列表 */
  public List<EPTradeInfo> getTxInfos() {
    return this.txInfos;
  }

  /**
   * 交易信息列表 */
  public void setTxInfos(List<EPTradeInfo> txInfos) {
    this.txInfos = txInfos;
  }
}
