//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.response;

import cn.com.antcloud.api.blockchain.v1_0_0.model.EPIssueHisInfo;
import cn.com.antcloud.api.product.AntCloudProdResponse;
import java.lang.Long;
import java.lang.String;
import java.util.List;

/**
 * 数字资产管理平台版通信息查询接口 */
public class QueryExchangeEpinfoResponse extends AntCloudProdResponse {
  private String epAnchor;

  private String epCode;

  private Long epFirstAmount;

  private String epIssueAccount;

  private Long epIssueDate;

  private List<EPIssueHisInfo> epIssueHistory;

  private String epName;

  private Long epOfflineIssueAmount;

  private Long epOfflineUnfreeze;

  private Long epOnlineIssueAmount;

  private Long epSelfAmount;

  private Long epSelfUnfreeze;

  private Long epStatus;

  private Long epTotalAmount;

  private String epType;

  private String extend;

  /**
   * 版通锚定物 */
  public String getEpAnchor() {
    return this.epAnchor;
  }

  /**
   * 版通锚定物 */
  public void setEpAnchor(String epAnchor) {
    this.epAnchor = epAnchor;
  }

  /**
   * 版通代码 */
  public String getEpCode() {
    return this.epCode;
  }

  /**
   * 版通代码 */
  public void setEpCode(String epCode) {
    this.epCode = epCode;
  }

  /**
   * 版通首发量 */
  public Long getEpFirstAmount() {
    return this.epFirstAmount;
  }

  /**
   * 版通首发量 */
  public void setEpFirstAmount(Long epFirstAmount) {
    this.epFirstAmount = epFirstAmount;
  }

  /**
   * 版通发行方账户 */
  public String getEpIssueAccount() {
    return this.epIssueAccount;
  }

  /**
   * 版通发行方账户 */
  public void setEpIssueAccount(String epIssueAccount) {
    this.epIssueAccount = epIssueAccount;
  }

  /**
   * 版通发行日时间戳 */
  public Long getEpIssueDate() {
    return this.epIssueDate;
  }

  /**
   * 版通发行日时间戳 */
  public void setEpIssueDate(Long epIssueDate) {
    this.epIssueDate = epIssueDate;
  }

  /**
   * 版通历史发行记录 */
  public List<EPIssueHisInfo> getEpIssueHistory() {
    return this.epIssueHistory;
  }

  /**
   * 版通历史发行记录 */
  public void setEpIssueHistory(List<EPIssueHisInfo> epIssueHistory) {
    this.epIssueHistory = epIssueHistory;
  }

  /**
   * 版通名称 */
  public String getEpName() {
    return this.epName;
  }

  /**
   * 版通名称 */
  public void setEpName(String epName) {
    this.epName = epName;
  }

  /**
   * 版通线下发行量 */
  public Long getEpOfflineIssueAmount() {
    return this.epOfflineIssueAmount;
  }

  /**
   * 版通线下发行量 */
  public void setEpOfflineIssueAmount(Long epOfflineIssueAmount) {
    this.epOfflineIssueAmount = epOfflineIssueAmount;
  }

  /**
   * 版通线下日解限量 */
  public Long getEpOfflineUnfreeze() {
    return this.epOfflineUnfreeze;
  }

  /**
   * 版通线下日解限量 */
  public void setEpOfflineUnfreeze(Long epOfflineUnfreeze) {
    this.epOfflineUnfreeze = epOfflineUnfreeze;
  }

  /**
   * 版通线上发行量 */
  public Long getEpOnlineIssueAmount() {
    return this.epOnlineIssueAmount;
  }

  /**
   * 版通线上发行量 */
  public void setEpOnlineIssueAmount(Long epOnlineIssueAmount) {
    this.epOnlineIssueAmount = epOnlineIssueAmount;
  }

  /**
   * 版通发行方自持量 */
  public Long getEpSelfAmount() {
    return this.epSelfAmount;
  }

  /**
   * 版通发行方自持量 */
  public void setEpSelfAmount(Long epSelfAmount) {
    this.epSelfAmount = epSelfAmount;
  }

  /**
   * 版通自持日解限量 */
  public Long getEpSelfUnfreeze() {
    return this.epSelfUnfreeze;
  }

  /**
   * 版通自持日解限量 */
  public void setEpSelfUnfreeze(Long epSelfUnfreeze) {
    this.epSelfUnfreeze = epSelfUnfreeze;
  }

  /**
   * 版通状态 0:正常 1:锁定 */
  public Long getEpStatus() {
    return this.epStatus;
  }

  /**
   * 版通状态 0:正常 1:锁定 */
  public void setEpStatus(Long epStatus) {
    this.epStatus = epStatus;
  }

  /**
   * 版通总发行量 */
  public Long getEpTotalAmount() {
    return this.epTotalAmount;
  }

  /**
   * 版通总发行量 */
  public void setEpTotalAmount(Long epTotalAmount) {
    this.epTotalAmount = epTotalAmount;
  }

  /**
   * 版通类型 */
  public String getEpType() {
    return this.epType;
  }

  /**
   * 版通类型 */
  public void setEpType(String epType) {
    this.epType = epType;
  }

  /**
   * 扩展字段 */
  public String getExtend() {
    return this.extend;
  }

  /**
   * 扩展字段 */
  public void setExtend(String extend) {
    this.extend = extend;
  }
}
