//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.response;

import cn.com.antcloud.api.blockchain.v1_0_0.model.NodeInfo;
import cn.com.antcloud.api.product.AntCloudProdResponse;
import java.lang.Boolean;
import java.lang.Long;
import java.lang.String;
import java.util.Date;
import java.util.List;

/**
 * 通过链id，获取链的相关信息 */
public class QueryBlockchainInfosResponse extends AntCloudProdResponse {
  private Long abnormalNodes;

  private String bizid;

  private Long blockHeight;

  private Date createTime;

  private Boolean isNormal;

  private Boolean isRole;

  private String name;

  private List<NodeInfo> nodeInfoList;

  private Long nodeNumber;

  private Long transactionSum;

  private String version;

  /**
   * 异常的节点数 */
  public Long getAbnormalNodes() {
    return this.abnormalNodes;
  }

  /**
   * 异常的节点数 */
  public void setAbnormalNodes(Long abnormalNodes) {
    this.abnormalNodes = abnormalNodes;
  }

  /**
   * 区块链id */
  public String getBizid() {
    return this.bizid;
  }

  /**
   * 区块链id */
  public void setBizid(String bizid) {
    this.bizid = bizid;
  }

  /**
   * 区块高度 */
  public Long getBlockHeight() {
    return this.blockHeight;
  }

  /**
   * 区块高度 */
  public void setBlockHeight(Long blockHeight) {
    this.blockHeight = blockHeight;
  }

  /**
   * 创建时间 */
  public Date getCreateTime() {
    return this.createTime;
  }

  /**
   * 创建时间 */
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  /**
   * 链的状态，是否正常 */
  public Boolean getIsNormal() {
    return this.isNormal;
  }

  /**
   * 链的状态，是否正常 */
  public void setIsNormal(Boolean isNormal) {
    this.isNormal = isNormal;
  }

  /**
   * 是否为管理员权限 */
  public Boolean getIsRole() {
    return this.isRole;
  }

  /**
   * 是否为管理员权限 */
  public void setIsRole(Boolean isRole) {
    this.isRole = isRole;
  }

  /**
   * 链的名字 */
  public String getName() {
    return this.name;
  }

  /**
   * 链的名字 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 节点信息 */
  public List<NodeInfo> getNodeInfoList() {
    return this.nodeInfoList;
  }

  /**
   * 节点信息 */
  public void setNodeInfoList(List<NodeInfo> nodeInfoList) {
    this.nodeInfoList = nodeInfoList;
  }

  /**
   * 节点数 */
  public Long getNodeNumber() {
    return this.nodeNumber;
  }

  /**
   * 节点数 */
  public void setNodeNumber(Long nodeNumber) {
    this.nodeNumber = nodeNumber;
  }

  /**
   * 链上交易数 */
  public Long getTransactionSum() {
    return this.transactionSum;
  }

  /**
   * 链上交易数 */
  public void setTransactionSum(Long transactionSum) {
    this.transactionSum = transactionSum;
  }

  /**
   * 链的版本 */
  public String getVersion() {
    return this.version;
  }

  /**
   * 链的版本 */
  public void setVersion(String version) {
    this.version = version;
  }
}
