//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.UpdateProductResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 变配，对已有的实例进行规格变更操作。 */
public class UpdateProductRequest extends AntCloudProdRequest<UpdateProductResponse> {
  @NotNull
  private String instanceId;

  @NotNull
  private String orderNo;

  @NotNull
  private String productCode;

  @NotNull
  private String specification;

  public UpdateProductRequest(String productInstanceId) {
    super("baas.ocp.product.update", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public UpdateProductRequest() {
    super("baas.ocp.product.update", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 产品实例Id	 */
  public String getInstanceId() {
    return this.instanceId;
  }

  /**
   * 产品实例Id	 */
  public void setInstanceId(String instanceId) {
    this.instanceId = instanceId;
  }

  /**
   * 订单号用于业务串联，以及幂等。目前为纯数字。保留使用大小写英文字符可能。 */
  public String getOrderNo() {
    return this.orderNo;
  }

  /**
   * 订单号用于业务串联，以及幂等。目前为纯数字。保留使用大小写英文字符可能。 */
  public void setOrderNo(String orderNo) {
    this.orderNo = orderNo;
  }

  /**
   * 产品码 全局唯一 */
  public String getProductCode() {
    return this.productCode;
  }

  /**
   * 产品码 全局唯一 */
  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }

  /**
   * 增量规格信息（JSON格式）会按照key进行排序 */
  public String getSpecification() {
    return this.specification;
  }

  /**
   * 增量规格信息（JSON格式）会按照key进行排序 */
  public void setSpecification(String specification) {
    this.specification = specification;
  }
}
