//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.UpdateCorporateExtensionserviceResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 用户更新扩展字段中的扩展字段 */
public class UpdateCorporateExtensionserviceRequest extends AntCloudProdRequest<UpdateCorporateExtensionserviceResponse> {
  @NotNull
  private String did;

  @NotNull
  private String extension;

  public UpdateCorporateExtensionserviceRequest(String productInstanceId) {
    super("baas.did.corporate.extensionservice.update", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public UpdateCorporateExtensionserviceRequest() {
    super("baas.did.corporate.extensionservice.update", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 需要更新的did doc对应的did字段；该did必须为调用者自己的did，或者托管给调用者的did */
  public String getDid() {
    return this.did;
  }

  /**
   * 需要更新的did doc对应的did字段；该did必须为调用者自己的did，或者托管给调用者的did */
  public void setDid(String did) {
    this.did = did;
  }

  /**
   * 修改后的全量扩展字段 */
  public String getExtension() {
    return this.extension;
  }

  /**
   * 修改后的全量扩展字段 */
  public void setExtension(String extension) {
    this.extension = extension;
  }
}
