//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.model.IdentityParam;
import cn.com.antcloud.api.blockchain.v1_0_0.response.StartIdentificationFaceauthResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 开始实人认证 */
public class StartIdentificationFaceauthRequest extends AntCloudProdRequest<StartIdentificationFaceauthResponse> {
  @NotNull
  private String authType;

  @NotNull
  private IdentityParam identityParam;

  private String returnUrl;

  @NotNull
  private String uid;

  public StartIdentificationFaceauthRequest(String productInstanceId) {
    super("baas.did.identification.faceauth.start", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public StartIdentificationFaceauthRequest() {
    super("baas.did.identification.faceauth.start", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 认证类型,枚举值 PC_AUTH、APP_AUTH */
  public String getAuthType() {
    return this.authType;
  }

  /**
   * 认证类型,枚举值 PC_AUTH、APP_AUTH */
  public void setAuthType(String authType) {
    this.authType = authType;
  }

  /**
   * 用户身份信息 */
  public IdentityParam getIdentityParam() {
    return this.identityParam;
  }

  /**
   * 用户身份信息 */
  public void setIdentityParam(IdentityParam identityParam) {
    this.identityParam = identityParam;
  }

  /**
   * 认证接口回调路径，POST接口 请求示例： { "certifyId":"0242de204e1a2c3ed6ee5e21d8a57a4c", "did":"xxxxx","vcId":"xxxxx" } */
  public String getReturnUrl() {
    return this.returnUrl;
  }

  /**
   * 认证接口回调路径，POST接口 请求示例： { "certifyId":"0242de204e1a2c3ed6ee5e21d8a57a4c", "did":"xxxxx","vcId":"xxxxx" } */
  public void setReturnUrl(String returnUrl) {
    this.returnUrl = returnUrl;
  }

  /**
   * 系统唯一id(商户须保证唯一) */
  public String getUid() {
    return this.uid;
  }

  /**
   * 系统唯一id(商户须保证唯一) */
  public void setUid(String uid) {
    this.uid = uid;
  }
}
