//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.model.AccountWholesaleParam;
import cn.com.antcloud.api.blockchain.v1_0_0.response.StartExchangeEpwholesaleResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import java.util.List;
import javax.validation.constraints.NotNull;

/**
 * 数字资产管理平台版通批发接口 */
public class StartExchangeEpwholesaleRequest extends AntCloudProdRequest<StartExchangeEpwholesaleResponse> {
  @NotNull
  private List<AccountWholesaleParam> accountList;

  @NotNull
  private String epCode;

  @NotNull
  private String epIssueAccount;

  @NotNull
  private String exchangeCode;

  public StartExchangeEpwholesaleRequest(String productInstanceId) {
    super("baas.digitalasset.exchange.epwholesale.start", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public StartExchangeEpwholesaleRequest() {
    super("baas.digitalasset.exchange.epwholesale.start", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 批发账户信息列表 */
  public List<AccountWholesaleParam> getAccountList() {
    return this.accountList;
  }

  /**
   * 批发账户信息列表 */
  public void setAccountList(List<AccountWholesaleParam> accountList) {
    this.accountList = accountList;
  }

  /**
   * 版通代码 */
  public String getEpCode() {
    return this.epCode;
  }

  /**
   * 版通代码 */
  public void setEpCode(String epCode) {
    this.epCode = epCode;
  }

  /**
   * 版通发行方账户 */
  public String getEpIssueAccount() {
    return this.epIssueAccount;
  }

  /**
   * 版通发行方账户 */
  public void setEpIssueAccount(String epIssueAccount) {
    this.epIssueAccount = epIssueAccount;
  }

  /**
   * 交易所代码 */
  public String getExchangeCode() {
    return this.exchangeCode;
  }

  /**
   * 交易所代码 */
  public void setExchangeCode(String exchangeCode) {
    this.exchangeCode = exchangeCode;
  }
}
