//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.StartExchangeEptradeResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.Long;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 数字资产管理平台交易接口 */
public class StartExchangeEptradeRequest extends AntCloudProdRequest<StartExchangeEptradeResponse> {
  @NotNull
  private Long epAmount;

  @NotNull
  private String epCode;

  @NotNull
  private String exchangeCode;

  @NotNull
  private String fromAccount;

  @NotNull
  private String toAccount;

  public StartExchangeEptradeRequest(String productInstanceId) {
    super("baas.digitalasset.exchange.eptrade.start", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public StartExchangeEptradeRequest() {
    super("baas.digitalasset.exchange.eptrade.start", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 交易数量 */
  public Long getEpAmount() {
    return this.epAmount;
  }

  /**
   * 交易数量 */
  public void setEpAmount(Long epAmount) {
    this.epAmount = epAmount;
  }

  /**
   * 版通代码 */
  public String getEpCode() {
    return this.epCode;
  }

  /**
   * 版通代码 */
  public void setEpCode(String epCode) {
    this.epCode = epCode;
  }

  /**
   * 交易所代码 */
  public String getExchangeCode() {
    return this.exchangeCode;
  }

  /**
   * 交易所代码 */
  public void setExchangeCode(String exchangeCode) {
    this.exchangeCode = exchangeCode;
  }

  /**
   * 卖方账户 */
  public String getFromAccount() {
    return this.fromAccount;
  }

  /**
   * 卖方账户 */
  public void setFromAccount(String fromAccount) {
    this.fromAccount = fromAccount;
  }

  /**
   * 买方账户 */
  public String getToAccount() {
    return this.toAccount;
  }

  /**
   * 买方账户 */
  public void setToAccount(String toAccount) {
    this.toAccount = toAccount;
  }
}
