//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.StartDidThreeelementResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 完成1.三要素认证；2创建did；3.颁发声明（声明该DID已经完成三要素认证） */
public class StartDidThreeelementRequest extends AntCloudProdRequest<StartDidThreeelementResponse> {
  @NotNull
  private String custumorUid;

  @NotNull
  private String verifyInfoId;

  @NotNull
  private String verifyInfoName;

  @NotNull
  private String verifyInfoPhone;

  public StartDidThreeelementRequest(String productInstanceId) {
    super("baas.mydid.did.threeelement.start", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public StartDidThreeelementRequest() {
    super("baas.mydid.did.threeelement.start", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 客户自有用户的唯一id */
  public String getCustumorUid() {
    return this.custumorUid;
  }

  /**
   * 客户自有用户的唯一id */
  public void setCustumorUid(String custumorUid) {
    this.custumorUid = custumorUid;
  }

  /**
   * 实名认证身份证号 */
  public String getVerifyInfoId() {
    return this.verifyInfoId;
  }

  /**
   * 实名认证身份证号 */
  public void setVerifyInfoId(String verifyInfoId) {
    this.verifyInfoId = verifyInfoId;
  }

  /**
   * 实名认证用户名 */
  public String getVerifyInfoName() {
    return this.verifyInfoName;
  }

  /**
   * 实名认证用户名 */
  public void setVerifyInfoName(String verifyInfoName) {
    this.verifyInfoName = verifyInfoName;
  }

  /**
   * 电话号码 */
  public String getVerifyInfoPhone() {
    return this.verifyInfoPhone;
  }

  /**
   * 电话号码 */
  public void setVerifyInfoPhone(String verifyInfoPhone) {
    this.verifyInfoPhone = verifyInfoPhone;
  }
}
