//
//  Copyright (c) 2015-present Alipay.com, https://www.alipay.com
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//  http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
//
package cn.com.antcloud.api.blockchain.v1_0_0.request;

import cn.com.antcloud.api.blockchain.v1_0_0.response.StartCertificationTwometaResponse;
import cn.com.antcloud.api.product.AntCloudProdRequest;
import java.lang.String;
import javax.validation.constraints.NotNull;

/**
 * 二要素实名认证 */
public class StartCertificationTwometaRequest extends AntCloudProdRequest<StartCertificationTwometaResponse> {
  @NotNull
  private String certNo;

  @NotNull
  private String name;

  @NotNull
  private String uid;

  public StartCertificationTwometaRequest(String productInstanceId) {
    super("baas.did.certification.twometa.start", "1.0", "Java-SDK-20190716", productInstanceId);
  }

  public StartCertificationTwometaRequest() {
    super("baas.did.certification.twometa.start", "1.0", null);
    this.setSdkVersion("Java-SDK-20190716");
  }

  /**
   * 身份证号码 */
  public String getCertNo() {
    return this.certNo;
  }

  /**
   * 身份证号码 */
  public void setCertNo(String certNo) {
    this.certNo = certNo;
  }

  /**
   * 姓名 */
  public String getName() {
    return this.name;
  }

  /**
   * 姓名 */
  public void setName(String name) {
    this.name = name;
  }

  /**
   * 系统唯一id(商户须保证唯一) */
  public String getUid() {
    return this.uid;
  }

  /**
   * 系统唯一id(商户须保证唯一) */
  public void setUid(String uid) {
    this.uid = uid;
  }
}
